const { __ } = wp.i18n;

jQuery(document).ready(function () {
	let should_cancel_action = false;
	function check_all(checked = true) {
		const all_post_type_associated = document.querySelectorAll('input[name=post_type_associated]');

		for (let i = 0; i < all_post_type_associated.length; i++) {
			const element = all_post_type_associated[i];
			element.checked = checked;
		}
	}

	function show_courses_list(show = true) {
		const courses_list = document.getElementById('ldie_courses_list');
		courses_list.style.display = show ? 'block' : 'none';

		const all_courses = document.getElementsByName('post_ids[]');

		for (let i = 0; i < all_courses.length; i++) {
			const element = all_courses[i];
			element.checked = false;
		}
	}

	function show_associated_content(show = true) {
		const associated_content = document.getElementById('ldie_associated_content');
		associated_content.style.display = show ? 'block' : 'none';
		check_all(show);
	}

	function show_export_type_content(show = true) {
		const export_type_options = document.getElementById('ldie_export_type');
		const all_export_type_option = document.getElementById(
			'learndash_import_export_post_type_radio_all_option'
		);

		export_type_options.style.display = show ? 'block' : 'none';
		all_export_type_option.checked = true;
		show_associated_content(show);
	}

	jQuery( '.sfwd_option_input_user_data input[name="user_meta"]' ).on( 'change', function() {
		var status = jQuery(this).val();
		if (status != 'yes') {
			jQuery(".sfwd_option_input_open_user_data").hide();
		} else {
			jQuery(".sfwd_option_input_open_user_data").show();
		}
		jQuery(".sfwd_option_input_open_user_data").hide();
	});

	const export_area = document.getElementById('ldie_export_area');
	if (export_area && export_area.style.display !== 'none') {
		fill_exported_files_list();
	}

	const export_type_radio_buttons = document.getElementsByName('export_type');

	for (let i = 0; i < export_type_radio_buttons.length; i++) {
		const export_type_radio = export_type_radio_buttons[i];
		export_type_radio.addEventListener('change', function (event) {
			const value = event.target.value;
			const checked = event.target.checked;

			if (value === 'all' && checked) {
				show_associated_content();
				show_courses_list(false);
			} else if (value === 'per-course' && checked) {
				show_associated_content(false);
				show_courses_list();
			}
		});
	}

	const export_select = document.getElementById('learndash_import_export_post_type_select');

	if (export_select) {
		export_select.addEventListener('change', function (event) {
			const value = event.target.value;
			const submit_button = document.getElementById('ldie_export');
			show_export_type_content('sfwd-courses' === value);

			submit_button.disabled = '' == value;
		});

		jQuery('#ldie_export_tab a.ldie_button').click(function () {
			var target = jQuery(this).data('target-content');
			jQuery('.ldie_plug_content_wrap').hide();
			jQuery('#' + target).show();
			if (target === 'ldie_export_area') {
				fill_exported_files_list();
			}
			jQuery('#ldie_export_tab a').removeClass('active');
			jQuery(this).addClass('active');
		});
	}

	async function check_reset_status() {
		const form_data = new FormData();
		form_data.append('action', 'ldie_reset_status');

		const response = await fetch(ld_import_export.ajax_url, {
			method: 'POST',
			credentials: 'same-origin',
			body: form_data,
		});
		const json = await response.json();
		return json;
	}

	// Reset data Form submit
	const reset_form = document.getElementById('learndash_import_export_form_reset');

	if (reset_form) {
		reset_form.addEventListener('submit', function (event) {
			event.preventDefault();

			const submit_button = document.getElementById('ldie_reset');
			submit_button.disabled = true;
			submit_button.innerHTML = __('Loading...', 'ea_import_export');

			jQuery
				.ajax({
					method: 'POST',
					url: ld_import_export.ajax_url,
					data: {
						action: 'ldie_reset_data',
					},
				})
				.done(function (response) {
					response = JSON.parse(response);
					should_cancel_action = true;
					const check_status_interval = setInterval(async () => {
						const status_response = await check_reset_status();
						if (
							status_response.reset_status === 'complete' ||
							status_response.reset_status === 'failed'
						) {
							clearInterval(check_status_interval);
							submit_button.disabled = false;
							submit_button.innerHTML = __('Reset', 'ea_import_export');
							alert(status_response.status + ': ' + status_response.message);
							await cancel_reset_action();
						}
					}, 5000);
				})
				.fail(function (response) {
					submit_button.disabled = false;
					submit_button.innerHTML = __('Reset', 'ea_import_export');
					// @todo add error handling
					if ('responseJSON' in response && !response.responseJSON.success) {
						alert(__('Error: ', 'ea_import_export') + response.responseJSON.data.message);
					} else {
						alert(__('Error: ', 'ea_import_export') + response.responseText);
					}
				});
		});
	}

	function get_hidden_fields(form) {
		const hidden = {};
		const hidden_fields = form.querySelectorAll('input[type=hidden]');

		for (let i = 0; i < hidden_fields.length; i++) {
			const element = hidden_fields[i];
			if ('' === element.value) {
				continue;
			}

			hidden[element.name] = element.value;
		}
		return hidden;
	}

	function download_file(src) {
		const a_element = document.createElement('a');

		a_element.href = src;
		a_element.style = 'visibility: hidden; position: absolute; top: 0; left: 0; z-index: -1;';
		a_element.setAttribute('download', '');

		const click_handler = () => {
			setTimeout(() => {
				this.removeEventListener('click', click_handler);
			}, 150);
		};
		document.body.appendChild(a_element);
		a_element.click();
		document.body.removeChild(a_element);
	}

	// Export data Form submit
	const export_form = document.getElementById('learndash_import_export_form_export');

	if (export_form) {
		export_form.addEventListener('submit', function (event) {
			event.preventDefault();

			const submit_button = document.getElementById('ldie_export');
			submit_button.disabled = true;
			submit_button.innerHTML = __('Loading...', 'ea_import_export');

			const form = event.target;

			const hidden = get_hidden_fields(form);

			const data_type = form.querySelector('input[name=data_type]:checked').value;
			const export_type = form.querySelector('input[name=export_type]:checked').value;
			const post_type_select = form.querySelector('select[name=post_type_select]').value;
			const max_chunk_select = form.querySelector('select[name=max_chunk_select]').value;
			const users_data = form.querySelector('input[name=user_meta]:checked').value;
			const opencourse_checkboxes = form.querySelector('input[name=opencourse_checkboxes]');
			let opencourse_data = jQuery(opencourse_checkboxes).is(':checked')? opencourse_checkboxes.value : '';
			const post_type_associated = form.querySelectorAll(
				'input[name=post_type_associated]:checked'
			);
			const global_content_setting = form.querySelectorAll(
				'input[name=global_contents_setting]:checked'
			);
			const post_ids = form.querySelectorAll('input[name=post_ids]:checked');
			const post_ids_checked = Array.from(post_ids).map((node) => node.value);
			const post_type_checked = Array.from(post_type_associated).map((node) => node.value);
			const global_content_setting_checked = Array.from(global_content_setting).map((node) => node.value);
			const body = {
				...hidden,
				action: 'export_ld_data',
				data_type,
				export_type,
				post_ids: JSON.stringify(post_ids_checked),
				max_chunk: max_chunk_select,
				post_types: JSON.stringify([post_type_select].concat(post_type_checked)),
				users_data,
				opencourse_data,
				content_global_setting: JSON.stringify( global_content_setting_checked ),
			};

			jQuery
				.ajax({
					method: 'POST',
					url: ld_import_export.ajax_url,
					data: body,
				})
				.done(function (response) {
					response = JSON.parse(response);

					if (response.file_status) {
						if (response.file_source) {
							download_file(response.file_source);
						}
						fill_exported_files_list();
						alert(response.status + ': ' + response.message);
					} else {
						alert(__('Error: ', 'ea_import_export') + response.message);
					}
				})
				.fail(function (response) {
					if ('responseJSON' in response && !response.responseJSON.success) {
						alert(__('Error: ', 'ea_import_export') + response.responseJSON.data.message);
					} else {
						alert(__('Error: ', 'ea_import_export') + response.responseText);
					}
				})
				.always(function () {
					submit_button.disabled = false;
					submit_button.innerHTML = __('Export: ', 'ea_import_export');
					form.reset();
					show_courses_list(false);
					show_export_type_content(false);
				});
		});

		const searchCourseInput = document.getElementById('ldie-export-search-course');
		const allCourses = document.querySelectorAll(
			'#ldie-all-courses p.ld-checkbox-input-wrapper[data-name]'
		);

		function handleCourseSearch(event) {
			const toSearch = event.target.value;
			const newRegex = new RegExp(toSearch, 'i');

			allCourses.forEach((course) => {
				const courseName = course.dataset.name;

				if (newRegex.test(courseName)) {
					course.style.display = '';
				} else {
					course.style.display = 'none';
				}
			});
		}

		searchCourseInput.addEventListener('keyup', handleCourseSearch);
	}

	async function get_exported_files() {
		try {
			// const hidden = get_hidden_fields(form);

			// const hidden_array = Object.keys(hidden);

			const form_data = new FormData();
			// for (let i = 0; i < hidden_array.length; i++) {
			//	 const index = hidden_array[i];
			//	 form_data.append(index, hidden[index]);
			// }

			form_data.append('action', 'ldie_export_get_files');

			const response = await fetch(ld_import_export.ajax_url, {
				method: 'POST',
				credentials: 'same-origin',
				body: form_data,
			});

			const json = await response.json();
			return json;
		} catch (err) {
			console.error(err.message);
		}
	}

	async function fill_exported_files_list() {
		const list_element = document.querySelector('#ldie_exported_files ul');
		const button_element = document.querySelector(
			'#ldie_exported_files button#ldie_export_delete_files'
		);
		const list = await get_exported_files();
		let html = '';

		if (! list || list.data.length === 0) {
			html =
				'<li>' +
				__('There are no Exported files available... yet', 'ea_import_export') +
				'</li>';
			list_element.innerHTML = html;
			button_element.style.display = 'none';
			return;
		}

		html +=
			'<li><strong>' +
			__('Directory Path', 'ea_import_export') +
			'</strong><strong>' +
			__('Zip File', 'ea_import_export') +
			'</strong></li>';

		for (let i = 0; i < list.data.length; i++) {
			const file = list.data[i];
			let zip_path = '';

			if (file.zip_path) {
				zip_path =
					'<a href="' +
					file.zip_path +
					'" download>' +
					__('Zip File', 'ea_import_export') +
					'</a>';
			}

			html += '<li><span>' + file.folder_path + '</span>' + zip_path + '</li>';
		}

		list_element.innerHTML = html;
		button_element.style.display = 'block';
	}

	const export_cleanup_form = document.getElementById('ldie_export_delete_files_form');

	if (export_cleanup_form) {
		export_cleanup_form.addEventListener('submit', async function (event) {
			event.preventDefault();
			try {
				const form = event.target;
				const hidden = get_hidden_fields(form);

				const hidden_array = Object.keys(hidden);
				const form_data = new FormData();
				for (let i = 0; i < hidden_array.length; i++) {
					const index = hidden_array[i];
					form_data.append(index, hidden[index]);
				}

				form_data.append('action', 'ldie_export_delete_files');

				await fetch(ld_import_export.ajax_url, {
					method: 'POST',
					credentials: 'same-origin',
					body: form_data,
				});
				await fill_exported_files_list();
			} catch (err) {
				console.error(err.message);
			}
		});
	}

	async function check_import_status(current_process) {
		try {
			const form = document.getElementById('learndash_import_export_form_import');
			const form_data = new FormData();

			const hidden = get_hidden_fields(form);
			const hidden_array = Object.keys(hidden);
			for (let i = 0; i < hidden_array.length; i++) {
				const index = hidden_array[i];
				form_data.append(index, hidden[index]);
			}

			form_data.append('action', 'ldie_import_status');
			form_data.append('current_process', current_process);

			const response = await fetch(ld_import_export.ajax_url, {
				method: 'POST',
				credentials: 'same-origin',
				body: form_data,
			});
			const json = await response.json();
			return json;
		} catch (err) {
			return null;
		}
	}

	async function cancel_import_queue() {
		const form = document.getElementById('learndash_import_export_form_import');

		try {
			const hidden = get_hidden_fields(form);

			const hidden_array = Object.keys(hidden);

			const form_data = new FormData();
			for (let i = 0; i < hidden_array.length; i++) {
				const index = hidden_array[i];
				form_data.append(index, hidden[index]);
			}

			form_data.append('action', 'ldie_import_cancel_queue');

			await fetch(ld_import_export.ajax_url, {
				method: 'POST',
				credentials: 'same-origin',
				body: form_data,
			});
		} catch (err) {
			console.error(err.message);
		}
	}

	async function cancel_reset_action() {
		const form = document.getElementById('learndash_import_export_form_reset');

		try {
			const hidden = get_hidden_fields(form);

			const hidden_array = Object.keys(hidden);
			const form_data = new FormData();
			for (let i = 0; i < hidden_array.length; i++) {
				const index = hidden_array[i];
				form_data.append(index, hidden[index]);
			}

			form_data.append('action', 'ldie_reset_cancel_action');

			await fetch(ld_import_export.ajax_url, {
				method: 'POST',
				credentials: 'same-origin',
				body: form_data,
			});
		} catch (err) {
			console.error(err.message);
		}
	}

	// BeforeUnload event listener to cancel queues
	window.addEventListener('beforeunload', async function (e) {
		try {
			const import_form = document.getElementById('learndash_import_export_form_import');
			const reset_form = document.getElementById('learndash_import_export_form_reset');
			if (document.body.contains(import_form) && should_cancel_action) {
				await cancel_import_queue();
			}
			if (document.body.contains(reset_form) && should_cancel_action) {
				await cancel_reset_action();
			}
		} catch (err) {
			console.error(err.message);
		}
		delete e['returnValue'];
	});

	function reset_import_process_data() {
		const file_elements = document.querySelectorAll('#ldie__process div.ldie__details');
		const status_elements = document.querySelectorAll(
			'#ldie__process div.ldie__process__content span.ldie__status'
		);
		const data_set_elements = document.querySelectorAll(
			'#ldie__process span[data-imported], #ldie__process span[data-to-import]'
		);

		file_elements.forEach(function (details_list) {
			details_list.innerHTML =
				'<div><span>' +
				__('File', 'ea_import_export') +
				'</span> <span>' +
				__('Status', 'ea_import_export') +
				'</span></div>';
		});

		status_elements.forEach(function (status_element) {
			status_element.removeAttribute('class');
			status_element.classList.add('ldie__status', 'ldie__status__loading');
			status_element.innerHTML = __('Pending', 'ea_import_export');
		});

		data_set_elements.forEach(function (data_set_element) {
			data_set_element.innerHTML = '0';
		});
	}

	// Import File Upload form
	const import_form = document.getElementById('learndash_import_export_form_import');

	if (import_form) {
		import_form.addEventListener('submit', function (event) {
			event.preventDefault();
			reset_import_process_data();

			const submit_button = document.getElementById('ldie_import');
			submit_button.disabled = true;
			submit_button.innerHTML = __('Loading...', 'ea_import_export');

			const form = event.target;

			const hidden = get_hidden_fields(form);
			var form_data = new FormData();

			var file_data = document.getElementById('ldie_import_file').files[0];
			const import_type = document.querySelector('input[name="import_type"]:checked').value;
			const slow_run_batch = document.querySelector('input[name="slow_run_batch"]').value;
			const is_slow_run_element = document.querySelector('input[name="is_slow_run"]:checked');
			const import_dir_element = document.querySelector('input[name="import_dir"]:checked');
			const import_dir = import_dir_element ? import_dir_element.value : null;
			const is_slow_run = is_slow_run_element ? is_slow_run_element.value : null;
			form_data.append('file', file_data);
			form_data.append('type', import_type);
			form_data.append('is_slow_run', is_slow_run);
			form_data.append('slow_run_batch', slow_run_batch);
			form_data.append('directory_path', import_dir);
			form_data.append('action', 'ldie_upload_import_file');

			const hidden_array = Object.keys(hidden);

			for (let i = 0; i < hidden_array.length; i++) {
				const index = hidden_array[i];
				form_data.append(index, hidden[index]);
			}

			jQuery
				.ajax({
					url: ld_import_export.ajax_url,
					dataType: 'text',
					cache: false,
					contentType: false,
					processData: false,
					data: form_data,
					type: 'post',
				})
				.done(function (response) {
					should_cancel_action = true;
					response = JSON.parse(response);
					if (response.status === 'success') {
						set_import_status_interval();
					} else {
						alert(__('Error: ', 'ea_import_export') + response.message);
					}
				})
				.fail(function (response) {
					try {
						const json = JSON.parse(response.responseText);
						alert(__('Error: ', 'ea_import_export') + json.data.message);
					} catch (e) {
						if ('responseJSON' in response && !response.responseJSON.success) {
							alert(__('Error: ', 'ea_import_export') + response.responseJSON.data.message);
						} else {
							alert(__('Error: ', 'ea_import_export') + response.responseText);
						}
					}
				})
				.always(function () {
					submit_button.disabled = false;
					submit_button.innerHTML = __('Import', 'ea_import_export');
					show_import_zip_input();
					show_import_uploads_directory(false);
					form.reset();
				});
		});

		const slow_run_check = document.querySelector('input[name="is_slow_run"]');
		slow_run_check.addEventListener('change', (e) => {
			const slow_run_input = document.getElementById('ldie_slow_run_batch_input');
			const is_checked = e.target.checked;
			slow_run_input.style.display = is_checked ? 'block' : 'none';
		});
		// ldie_slow_run_batch_input

		function show_import_zip_input(show = true) {
			const zip_uploader_dir = document.getElementById('ldie-import-zip-uploader');
			zip_uploader_dir.style.display = show ? '' : 'none';
		}

		function show_import_uploads_directory(show = true) {
			const uploads_dir = document.getElementById('ldie-import-uploads-dir');
			uploads_dir.style.display = show ? '' : 'none';
		}

		const import_type_radio_buttons = document.getElementsByName('import_type');

		for (let i = 0; i < import_type_radio_buttons.length; i++) {
			const import_type_radio = import_type_radio_buttons[i];
			import_type_radio.addEventListener('change', function (event) {
				const value = event.target.value;
				const checked = event.target.checked;

				if (value === 'zip' && checked) {
					show_import_zip_input();
					show_import_uploads_directory(false);
				} else if (value === 'dir' && checked) {
					show_import_zip_input(false);
					show_import_uploads_directory();
				}
			});
		}
	}

	function change_process_status(element, status) {
		if ( element ) {
			if (status === 'complete' || status === 'success') {
				element.classList.remove('ldie__status__loading');
				element.classList.add('ldie__status__completed');
				element.innerText = __('Completed', 'ea_import_export');
			} else if (status === 'loading') {
				element.innerText = __('Loading', 'ea_import_export');
			} else if (status === 'in-progress') {
				element.innerText = __('In Progress', 'ea_import_export');
			} else if (status === 'pending') {
				element.innerText = __('Pending', 'ea_import_export');
			} else {
				element.classList.remove('ldie__status__loading');
				element.classList.add('ldie__status__error');
				element.innerText =
					status === 'canceled'
						? __('Canceled', 'ea_import_export')
						: __('Error', 'ea_import_export');
			}
		}
	}

	// Fill files on details block
	function fill_files_data_details(element_key, files) {
		const element = document.querySelector('#ldie_' + element_key + ' div.ldie__details');
		let html = '';

		if (element.children.length > 1) {
			return;
		}

		for (let i = 0; i < files.length; i++) {
			const file = files[i];
			html +=
				'<div data-file="' +
				file.filename +
				'"><span>' +
				file.filename +
				'</span> <span class="ldie__status ldie__status__loading">' +
				__('Loading', 'ea_import_export') +
				'</span></div>';
		}

		element.insertAdjacentHTML('beforeend', html);
	}

	function update_files_status_details(element_key, files) {
		const element = document.querySelector('#ldie_' + element_key + ' div.ldie__details');

		for (let i = 0; i < files.length; i++) {
			const file = files[i];
			const status_element = element.querySelector(
				'div[data-file="' + file.filename + '"] span.ldie__status'
			);
			change_process_status(status_element, file.status);
		}
	}

	// Fill to-import/imported data
	function fill_count_data_details(element_key, imported, to_import) {
		const imported_element = document.querySelector(
			'#ldie_' + element_key + ' span[data-imported]'
		);
		const to_import_element = document.querySelector(
			'#ldie_' + element_key + ' span[data-to-import]'
		);

		imported_element.innerHTML = imported;
		to_import_element.innerHTML = to_import;
	}

	function update_imported_data_details(element_key, imported) {
		const imported_element = document.querySelector(
			'#ldie_' + element_key + ' span[data-imported]'
		);

		imported_element.innerHTML = imported;
	}

	// Import Process
	async function set_import_status_interval() {
		const submit_button = document.getElementById('ldie_import');
		const process_main_element = document.getElementById('ldie__process');

		process_main_element.style.removeProperty('display');

		let current_process = 'analyze';
		let onetime_fill_action = true;

		const check_status_interval = setInterval(async () => {
			const response = await check_import_status(current_process);

			if (response === null) {
				clearInterval(check_status_interval);
				await cancel_import_queue();
				submit_button.disabled = false;
				submit_button.innerHTML = 'Import';
				alert(__('Unexpected Error: ', 'ea_import_export') + err.message);
				return;
			}

			if (!('process' in response.data)) {
				return;
			}

			const processes = response.data.process;
			const keys = Object.keys(processes);

			for (let i = 0; i < keys.length; i++) {
				const process_key = keys[i];

				if (
					processes[process_key].status !== 'pending' ||
					processes[process_key].status !== 'in-progress'
				) {
					const element = document.querySelector(
						'#ldie_' + process_key + ' div.ldie__process__content span.ldie__status'
					);
					change_process_status(element, processes[process_key].status);
				}

				if (processes[process_key].status === 'in-progress') {
					current_process = process_key;
					break;
				}
			}

			if (processes.analyze.status !== 'complete') {
				fill_count_data_details(
					'analyze',
					processes.analyze.analyzed_files,
					processes.analyze.total_files
				);
			}

			if (onetime_fill_action && processes.analyze.status === 'complete') {
				fill_files_data_details('global_settings', processes.global_settings.files);
				fill_count_data_details(
					'global_settings',
					processes.global_settings.imported,
					processes.global_settings.to_import
				);
				fill_files_data_details('users_data', processes.users_data.files);
				fill_count_data_details(
					'users_data',
					processes.users_data.imported,
					processes.users_data.to_import
				);
				fill_files_data_details('categories', processes.categories.files);
				fill_count_data_details(
					'categories',
					processes.categories.imported,
					processes.categories.to_import
				);
				fill_files_data_details('quiz_pro', processes.quiz_pro.files);
				fill_count_data_details(
					'quiz_pro',
					processes.quiz_pro.imported,
					processes.quiz_pro.to_import
				);
				fill_files_data_details('posts', processes.posts.files);
				fill_count_data_details('posts', processes.posts.imported, processes.posts.to_import);

				fill_count_data_details('mapper', processes.mapper.mapped, processes.mapper.to_map);

				fill_count_data_details('user_mapper', processes.user_mapper.mapped, processes.user_mapper.to_map);
				onetime_fill_action = false;
			}

			if (!onetime_fill_action && processes.analyze.status === 'complete') {

				if ('files' in processes.global_settings) {
					update_files_status_details('global_settings', processes.global_settings.files);
				}

				if ('files' in processes.users_data) {
					update_files_status_details('users_data', processes.users_data.files);
				}

				if ('files' in processes.categories) {
					update_files_status_details('categories', processes.categories.files);
				}
				if ('files' in processes.quiz_pro) {
					update_files_status_details('quiz_pro', processes.quiz_pro.files);
				}
				if ('files' in processes.posts) {
					update_files_status_details('posts', processes.posts.files);
				}

				update_imported_data_details('global_settings', processes.global_settings.imported);
				update_imported_data_details('users_data', processes.users_data.imported);
				update_imported_data_details('categories', processes.categories.imported);
				update_imported_data_details('quiz_pro', processes.quiz_pro.imported);
				update_imported_data_details('posts', processes.posts.imported);
				update_imported_data_details('mapper', processes.mapper.mapped);
				update_imported_data_details('user_mapper', processes.user_mapper.mapped);
			}

			if (response.data.completed || response.status === 'error') {
				clearInterval(check_status_interval);
				await cancel_import_queue();
				submit_button.disabled = false;
				submit_button.innerHTML = __('Import', 'ea_import_export');
				alert(response.status + ': ' + response.message);
			}
		}, 10000);
	}

	// Details buttons
	const details_buttons = document.querySelectorAll('.ldie__button__details');
	details_buttons.forEach((button) => {
		button.addEventListener('click', function (event) {
			const button_element = event.target;
			const item_container = button_element.closest('.ldie__process__item');
			const details_container = item_container.querySelector('.ldie__details');

			if (details_container.classList.contains('ldie__details--is-hidden')) {
				details_container.classList.remove('ldie__details--is-hidden');
			} else {
				details_container.classList.add('ldie__details--is-hidden');
			}
		});
	});
});
