<?php
/**
 * LDIE import export class
 *
 * @since 1.0.0
 * @package ea-import-export/admin/includes
 * Contributor: Jonatan Treviño
 */

namespace LDIE\Admin;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Ld_Admin_Export_File_All_Data' ) ) {
	/**
	 * Export class
	 */
	class Ld_Admin_Export_File_All_Data extends Ld_Admin_Export_Data {

		protected function export( $post_types ) {

			if ( count( $post_types ) === 1 && 'sfwd-quiz' === $post_types[0] ) {
				$post_types[] = 'sfwd-question';
			}

			foreach ( $post_types as $post_type ) {
				$post_data = $this->get_post_data( $post_type );
				if ( ! $post_data ) {
					continue;
				}

				$data_to_save = [];

				foreach ( $post_data as $data ) {
					$data_to_save[] = $this->exporter->generate_data( $data );
				}

				$this->fs->create_files( $data_to_save, $post_type );
			}

			if ( in_array( 'sfwd-quiz', $post_types, true ) || in_array( 'sfwd-question', $post_types, true ) ) {
				$quiz_pro_to_save  = [];
				$exported_quiz_pro = $this->get_question_data();

				foreach ( $exported_quiz_pro['questions'] as $key => $questions ) {
					if ( 0 === $key ) {
						$quiz_pro_to_save[] = $this->exporter->generate_quiz_pro_data(
							[
								'questions'  => $questions,
								'categories' => $exported_quiz_pro['categories'],
							]
						);
						continue;
					}
					$quiz_pro_to_save[] = $this->exporter->generate_quiz_pro_data(
						[
							'questions'  => $questions,
							'categories' => [],
						]
					);
				}

				$this->fs->create_files( $quiz_pro_to_save, 'quiz_pro' );
			}
		}

		/**
		 * Get_post_data
		 * get post value from database
		 *
		 * @since 1.0.0
		 * @param String $selected Post type.
		 * @throws \Exception When there are no Posts in the selected Post Type.
		 * @return array
		 */
		private function get_post_data( $selected = null ) {
			if ( ! $selected ) {
				throw new \Exception( esc_html__( 'Select a Post Type', 'ea_import_export' ) );
			}

			$raw_posts = $this->prepare_post( $selected );

			if ( count( $raw_posts ) === 0 ) {
				return null;
			}

			$structured_posts = [];
			foreach ( $raw_posts as $data ) {
				// Post data.
				$post_data = (array) $data;

				// Category.
				$terms = $this->get_terms( $data->ID );
				if ( $terms ) {
					$post_data['category'] = $terms;
				}

				// Meta.
				$meta = get_post_meta( $data->ID );
				if ( count( $meta ) > 0 ) {
					$post_data['meta'] = $meta;
				}

				$post_data                     = $this->export_media_files( $data->ID, $selected, $post_data );
				$structured_posts[ $data->ID ] = $post_data;
			}

			return array_chunk( $structured_posts, $this->max_chunk, true );
		}

		/**
		 * Prepare_post
		 * prepare post to retrieve the data
		 *
		 * @since 1.0.0
		 * @param Array $post_types arguments.
		 * @return object
		 */
		private function prepare_post( $post_types = null ) {
			if ( ! $post_types ) {
				return;
			}

			$all_result = [];
			foreach ( (array) $post_types as $post_type ) {
				$args = [
					'posts_per_page' => $this->limit,
					'post_type'      => $post_type,
					'post_status'    => 'any',
				];

				$result = get_posts( $args );
				if ( count( $result ) > 0 ) {
					$all_result = array_merge( $all_result, $result );
				}
			}

			return $all_result;
		}
	}
}
