<?php
/**
 * LDIE import export class
 *
 * @since 1.0.0
 * @package ea-import-export/admin/includes
 * Contributor: Jonatan Treviño
 */

namespace LDIE\Admin;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Ld_Admin_Export_File_Per_Course' ) ) {
	/**
	 * Export class
	 */
	class Ld_Admin_Export_File_Per_Course extends Ld_Admin_Export_Data {

		protected function export( $course_ids ) {
			$post_groups = [];
			$all_posts   = [];

			$quiz_ids              = [];
			$question_post_ids     = [];
			$quiz_pro_ids          = [];
			$quiz_question_pro_ids = [];

			$post_types = [
				'sfwd-courses',
				'sfwd-lessons',
				'sfwd-topic',
				'sfwd-quiz',
				'sfwd-question',
				'sfwd-certificates',
				'groups',
				'sfwd-assignment',
			];

			foreach ( $course_ids as $course_id ) {
				$posts     = $this->get_posts_by_meta( $course_id, $post_types );
				$all_posts = array_merge( $all_posts, $posts );
			}

			foreach ( $all_posts as $post ) {
				$post_data         = (array) $post;
				$current_post_type = $post_data['post_type'];

				if ( isset( $post_groups[ $current_post_type ][ $post->ID ] ) ) {
					continue;
				}

				$post_data = $this->prepare_post_per_course( $current_post_type, $post_data );

				$post_groups[ $current_post_type ][ $post->ID ] = $post_data;

				if ( 'sfwd-quiz' === $current_post_type ) {
					$quiz_ids[]     = $post->ID;
					$quiz_pro_ids[] = $post_data['meta']['quiz_pro_id'][0];
				}
			}

			foreach ( $quiz_ids as $quiz_id ) {
				$posts             = $this->get_quiz_posts_by_meta( $quiz_id, $post_types );
				$question_post_ids = array_merge( $question_post_ids, $posts );
			}

			foreach ( $question_post_ids as $post ) {
				$post_data         = (array) $post;
				$current_post_type = $post_data['post_type'];

				if ( isset( $post_groups[ $current_post_type ][ $post->ID ] ) ) {
					continue;
				}

				$post_data = $this->prepare_post_per_course( $current_post_type, $post_data );

				$post_groups[ $current_post_type ][ $post->ID ] = $post_data;

				if ( 'sfwd-question' === $current_post_type ) {
					$quiz_question_pro_ids[] = $post_data['meta']['question_pro_id'][0];
				}
			}

			$this->export_by_post_groups( $post_groups );

			if ( ! empty( $quiz_question_pro_ids ) ) {
				$quiz_pro_to_save  = [];
				$exported_quiz_pro = $this->get_question_data( $quiz_question_pro_ids );

				foreach ( $exported_quiz_pro['questions'] as $key => $questions ) {
					if ( 0 === $key ) {
						$quiz_pro_to_save[] = $this->exporter->generate_quiz_pro_data(
							[
								'questions'  => $questions,
								'categories' => $exported_quiz_pro['categories'],
							]
						);
						continue;
					}
					$quiz_pro_to_save[] = $this->exporter->generate_quiz_pro_data(
						[
							'questions'  => $questions,
							'categories' => [],
						]
					);
				}

				$this->fs->create_files( $quiz_pro_to_save, 'quiz_pro' );
			}
		}

		private function get_posts_by_meta( $course_id, $post_types ) {
			global $wpdb;
			$post_ids = $wpdb->get_results( $wpdb->prepare( "SELECT post_id FROM $wpdb->postmeta WHERE (meta_key = %s AND meta_value = %d) OR (meta_key = %s AND meta_value = %d) ORDER BY post_id ASC", 'ld_course_' . $course_id, $course_id, 'course_id', $course_id ), ARRAY_A );
			$post_ids = array_map( 'intval', array_column( $post_ids, 'post_id' ) );
			$post_ids = array_merge( $post_ids, [ $course_id ] );

			if ( empty( $post_ids ) ) {
				return [];
			}

			$args = [
				'posts_per_page' => $this->limit,
				'post_type'      => $post_types,
				'post_status'    => 'any',
				'post__in'       => $post_ids,
			];
			return get_posts( $args );
		}

		private function get_quiz_posts_by_meta( $quiz_id, $post_types ) {
			global $wpdb;
			$quizzes_questions = $wpdb->get_results( $wpdb->prepare( "SELECT post_id FROM $wpdb->postmeta WHERE meta_key = %s AND meta_value = %d", 'quiz_id', $quiz_id ), ARRAY_A );
			$quizzes_questions = array_map( 'intval', array_column( $quizzes_questions, 'post_id' ) );

			if ( empty( $quizzes_questions ) ) {
				return [];
			}

			$args = [
				'posts_per_page' => $this->limit,
				'post_type'      => $post_types,
				'post_status'    => 'any',
				'post__in'       => $quizzes_questions,
			];
			return get_posts( $args );
		}

		private function export_by_post_groups( $post_groups ) {
			foreach ( $post_groups as $post_type => $posts ) {
				$post_data = array_chunk( $posts, $this->max_chunk, true );

				if ( ! $post_data ) {
					continue;
				}

				$data_to_save = [];

				foreach ( $post_data as $data ) {
					$data_to_save[] = $this->exporter->generate_data( $data );
				}

				$this->fs->create_files( $data_to_save, $post_type );
			}
		}

		private function prepare_post_per_course( $current_post_type, $post_data ) {
			$terms = $this->get_terms( $post_data['ID'] );

			if ( $terms ) {
				$post_data['category'] = $terms;
			}

			$meta = get_post_meta( $post_data['ID'] );
			if ( count( $meta ) > 0 ) {
				$post_data['meta'] = $meta;
			}

			return $this->export_media_files( $post_data['ID'], $current_post_type, $post_data );
		}
	}
}
