<?php
/**
 * LDIE import export class
 *
 * @since 1.0.0
 * @package ea-import-export/admin/includes
 * Contributor: Jonatan Treviño
 */

namespace LDIE\Admin;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Ld_Admin_Export_Media' ) ) {
	/**
	 * Export class
	 */
	class Ld_Admin_Export_Media {

		/**
		 * The name/filepaths of the expoted files
		 *
		 * @var Array
		 */
		private $files = [];

		private $fs = null;


		public function __construct( $fs ) {
			$this->fs = $fs;
		}

		public function download_files() {
			$this->move_files_to_download_folder();
		}

		private function move_files_to_download_folder() {
			foreach ( $this->files as $file ) {
				$this->fs->copy_file_to_export( $file );
			}
		}


		public function add_file( $file ) {
			$this->files[] = $file;
		}

		public function add_files( $files ) {
			$this->files = array_merge( $this->files, $files );
		}

		public function get_files() {
			return $this->files;
		}
	}
}
