<?php
/**
 * LDIE import export class
 *
 * @since 1.0.0
 * @package ea-import-export/admin/includes
 * Contributor: Jonatan Treviño
 */

namespace LDIE\Admin;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Ld_Admin_Export_XML_File' ) ) {

	/**
	 * Export class
	 */
	class Ld_Admin_Export_XML_File {

		/**
		 * Indexes formatted.
		 *
		 * @param String $index Index.
		 * @return void
		 */
		private function format_index( $index = null ) {
			if ( ! $index ) {
				return;
			}

			$toreformat = [
				'ID'           => 'wp_post_id',
				'post_author'  => 'dc_creator',
				'post_content' => 'content_encoded',
				'post_excerpt' => 'excerpt_encoded',
				'guid'         => [ 'isPermaLink|false' ],
			];

			if ( ! isset( $toreformat[ $index ] ) ) {
				return 'wp_' . $index;
			}

			if ( is_array( $toreformat[ $index ] ) ) {
				$bdata = explode( '|', $toreformat[ $index ][0] );
				return $bdata;
			} else {
				return ( $toreformat[ $index ] ) ? $toreformat[ $index ] : 'wp_' . $index;
			}
		}

		/**
		 * Undocumented function
		 *
		 * @param Array $data data.
		 * @return void
		 */
		public function generate_data( $data = null ) {
			if ( ! $data ) {
				return;
			}

            // phpcs:disable
            $doc = new \DOMDocument();
            $doc->loadXML('<?xml version="1.0" encoding="UTF-8" ?><channel></channel>');
            $doc->preservWhiteSpace = false;
            $doc->formatOutput      = true;

            $channel = $doc->documentElement;
            // phpcs:enable

			$flag  = $doc->createElement( 'transkey' );
			$field = $doc->createElement( 'keyid', md5( 'ldie' ) );
			$flag->appendChild( $field );
			$channel->appendChild( $flag );

			foreach ( $data as $id => $row ) {

				$item = $doc->createElement( 'item' );
				foreach ( $row as $index => $val ) {

					// if category do different thing.
					if ( 'category' === $index ) {
						$existing_categories = [];

						foreach ( $val as $index => $cat ) {

							if ( in_array( $cat['nicename'], $existing_categories, true ) ) {
								continue;
							}
							$existing_categories[] = $cat['nicename'];

							if ( is_numeric( $cat['name'] ) ) {
								$child_cat = $doc->createElement( 'category', $cat['name'] );
							} else {
								$child_cat       = $doc->createElement( 'category' );
								$child_cat_cdata = $this->cdata_data( $child_cat, $cat['name'] );
								$child_cat->appendChild( $child_cat_cdata );
							}

							$child_attribute_domain          = $doc->createAttribute( 'domain' );
							$child_attribute_domain->value   = $cat['domain'];
							$child_attribute_nicename        = $doc->createAttribute( 'nicename' );
							$child_attribute_nicename->value = $cat['nicename'];
							$child_cat->appendChild( $child_attribute_domain );
							$child_cat->appendChild( $child_attribute_nicename );
							$item->appendChild( $child_cat );

							// xml structure design for LD.
							$ld_cat      = $doc->createElement( 'ld_category' );
							$ld_slug     = $doc->createElement( 'ld_slug', $cat['nicename'] );
							$ld_taxonomy = $doc->createElement( 'ld_taxonomy', $cat['domain'] );
							$ld_name     = $doc->createElement( 'ld_cat_name', $cat['name'] );
							$ld_cat->appendChild( $ld_name );
							$ld_cat->appendChild( $ld_slug );
							$ld_cat->appendChild( $ld_taxonomy );
							$item->appendChild( $ld_cat );
						}

						// continue the loop and ignore below codes.
						continue;
					}

					if ( 'meta' === $index ) {
						foreach ( $val as $key => $value ) {
							$formatted = $this->format_index( 'postmeta' );
							$postmeta  = $doc->createElement( $formatted );

							$formatted_key        = $this->format_index( 'meta_key' );
							$child_meta_key       = $doc->createElement( $formatted_key );
							$child_meta_key_cdata = $this->cdata_data( $child_meta_key, $key );
							$child_meta_key->appendChild( $child_meta_key_cdata );

							$formatted_value = $this->format_index( 'meta_value' );

							if ( is_numeric( $value[0] ) ) {
								$child_meta_value = $doc->createElement( $formatted_value, $value[0] );
							} else {
								$child_meta_value       = $doc->createElement( $formatted_value );
								$child_meta_value_cdata = $this->cdata_data( $child_meta_value, $value[0] );
								$child_meta_value->appendChild( $child_meta_value_cdata );
							}

							$postmeta->appendChild( $child_meta_key );
							$postmeta->appendChild( $child_meta_value );

							$item->appendChild( $postmeta );
						}

						// continue the loop and ignore below codes.
						continue;
					}

					$formatted = $this->format_index( $index );
					if ( is_array( $formatted ) ) {
						$child                  = $doc->createElement( $index, $val );
						$child_attribute        = $doc->createAttribute( $formatted[0] );
						$child_attribute->value = $formatted[1];
						$child->appendChild( $child_attribute );
					} else {
						if ( is_numeric( $val ) ) {
							$child = $doc->createElement( $formatted, $val );
						} else {
							$child = $doc->createElement( $formatted );

							if ( in_array( $formatted, [ 'content_encoded', 'excerpt_encoded', 'wp_post_content_filtered' ], true ) ) {
								$keep_nl = true;
							} else {
								$keep_nl = false;
							}

							if ( is_array( $val ) ) {
								$child_value = $this->cdata_data( $child, json_encode( $val ), $keep_nl );
							} else {
								$child_value = $this->cdata_data( $child, $val, $keep_nl );
							}
							$child->appendChild( $child_value );
						}
					}

					$item->appendChild( $child );
				}

				$channel->appendChild( $item );
			}

			return $doc->saveXML();
		}

		/**
		 * Cdata_data?
		 *
		 * @param Unkown $new_child .
		 * @param Unkown $value .
		 * @return unknown
		 */
		private function cdata_data( $new_child, $value, $keep_nl = false ) {
			$node = dom_import_simplexml( $new_child );
			// phpcs:ignore
			$no   = $node->ownerDocument;

			if ( $keep_nl ) {
				$value = str_replace( [ "\r\n", "\n", "\r" ], '{ldie_line_break}', $value );
				$value = str_replace( '{ldie_line_break}{ldie_line_break}', '{ldie_line_break}', $value );
			} else {
				$value = preg_replace( "/\r|\n/", ' ', $value );
			}
			return $no->createCDATASection( $value );
		}

		public function generate_categories_data( $categories ) {
			if ( ! $categories ) {
				return;
			}

			// phpcs:disable
            $doc = new \DOMDocument();
            $doc->loadXML('<?xml version="1.0" encoding="UTF-8" ?><channel></channel>');
            $doc->preservWhiteSpace = false;
            $doc->formatOutput      = true;

            $channel = $doc->documentElement;
            // phpcs:enable

			$flag  = $doc->createElement( 'transkey' );
			$field = $doc->createElement( 'keyid', md5( 'ldie' ) );
			$flag->appendChild( $field );
			$channel->appendChild( $flag );

			$existing_categories = [];

			// generate taxonomies.
			$cat_formatted = $this->format_index( 'category' );
			foreach ( $categories as $index => $row_cat ) {
				$cat = $doc->createElement( $cat_formatted );

				if ( in_array( $row_cat['category_nicename'], $existing_categories, true ) ) {
					continue;
				}
				$existing_categories[] = $row_cat['category_nicename'];

				// term id.
				$id_formatted = $this->format_index( 'term_id' );
				$cat_term_id  = $doc->createElement( $id_formatted, $row_cat['term_id'] );

				$taxonomy_formatted = $this->format_index( 'term_taxonomy' );
				if ( is_numeric( $row_cat['taxonomy'] ) ) {
					$cat_taxonomy = $doc->createElement( $taxonomy_formatted, $row_cat['taxonomy'] );
				} else {
					$cat_taxonomy       = $doc->createElement( $taxonomy_formatted );
					$cat_taxonomy_cdata = $this->cdata_data( $cat_taxonomy, $row_cat['taxonomy'] );
					$cat_taxonomy->appendChild( $cat_taxonomy_cdata );
				}

				$nicename_formatted = $this->format_index( 'category_nicename' );
				if ( is_numeric( $row_cat['category_nicename'] ) ) {
					$cat_nicename = $doc->createElement( $nicename_formatted, $row_cat['category_nicename'] );
				} else {
					$cat_nicename       = $doc->createElement( $nicename_formatted );
					$cat_nicename_cdata = $this->cdata_data( $cat_nicename, $row_cat['category_nicename'] );
					$cat_nicename->appendChild( $cat_nicename_cdata );
				}

				$parent_formatted = $this->format_index( 'category_parent' );
				$cat_parent       = $doc->createElement( $parent_formatted, $row_cat['category_parent'] );

				$cat_name_formatted = $this->format_index( 'cat_name' );
				if ( is_numeric( $row_cat['cat_name'] ) ) {
					$cat_name = $doc->createElement( $cat_name_formatted, $row_cat['cat_name'] );
				} else {
					$cat_name      = $doc->createElement( $cat_name_formatted );
					$cat_name_data = $this->cdata_data( $cat_name, $row_cat['cat_name'] );
					$cat_name->appendChild( $cat_name_data );
				}

				$cat->appendChild( $cat_term_id );
				$cat->appendChild( $cat_taxonomy );
				$cat->appendChild( $cat_nicename );
				$cat->appendChild( $cat_parent );
				$cat->appendChild( $cat_name );
				$channel->appendChild( $cat );
			}

			return $doc->saveXML();
		}

		public function generate_quiz_pro_data( $data ) {
			if ( ! $data ) {
				return;
			}

			// phpcs:disable
            $doc = new \DOMDocument();
            $doc->loadXML('<?xml version="1.0" encoding="UTF-8" ?><channel></channel>');
            $doc->preservWhiteSpace = false;
            $doc->formatOutput      = true;

            $channel = $doc->documentElement;
            // phpcs:enable

			$flag  = $doc->createElement( 'transkey' );
			$field = $doc->createElement( 'keyid', md5( 'ldie' ) );
			$flag->appendChild( $field );
			$channel->appendChild( $flag );

			$questions = $data['questions'];

			if ( $questions ) {
				$q_pro = $doc->createElement( 'quiz_pro_questions' );

				foreach ( $questions as $question ) {
					$question_item       = $doc->createElement( 'q_pro_question' );
					$question_item_cdata = $this->cdata_data( $question_item, serialize( $question ) );
					$question_item->appendChild( $question_item_cdata );
					$q_pro->appendChild( $question_item );
				}

				$channel->appendChild( $q_pro );
			}

			$quiz_pro_category_elements = $doc->createElement( 'quiz_pro_categories' );
			$quiz_pro_categories        = $data['categories'];

			foreach ( $quiz_pro_categories as $quiz_pro_category ) {
				$element_category      = $doc->createElement( 'category' );
				$element_category_id   = $doc->createElement( 'id', $quiz_pro_category['id'] );
				$element_category_name = $doc->createElement( 'name', $quiz_pro_category['name'] );

				$element_category->appendChild( $element_category_id );
				$element_category->appendChild( $element_category_name );
				$quiz_pro_category_elements->appendChild( $element_category );
			}
			$channel->appendChild( $quiz_pro_category_elements );

			return $doc->saveXML();
		}
	}
}
