<?php
/**
 * LDIE Global Content class
 *
 * @since 1.0.0
 * @package ea-import-export/admin/includes
 * Contributor: Honors WP
 */

namespace LDIE\Admin;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Ld_Admin_Global_Content_Setting' ) ) {

	/**
	 * Ld_Admin_Global_Content_Setting class
	 */
	class Ld_Admin_Global_Content_Setting {

		/**
		 * Fetch courses global settings
		 *
		 * @return array
		 */
		public static function global_course_settings() {
			$course_settings = array();

			if ( class_exists( '\LearnDash_Settings_Courses_Management_Display' ) ) {
				$course_settings['learndash_settings_courses_management_display'] = \LearnDash_Settings_Courses_Management_Display::get_section_settings_all();
			}

			if ( class_exists( '\LearnDash_Settings_Courses_Taxonomies' ) ) {
				$course_settings['learndash_settings_courses_taxonomies'] = \LearnDash_Settings_Courses_Taxonomies::get_section_settings_all();
			}

			if ( class_exists( '\LearnDash_Settings_Courses_CPT' ) ) {
				$course_settings['learndash_settings_courses_cpt'] = \LearnDash_Settings_Courses_CPT::get_section_settings_all();
			}

			return $course_settings;
		}

		/**
		 * Fetch lesson global settings
		 *
		 * @return array
		 */
		public static function global_lesson_settings() {
			$lesson_setting = array();

			if ( class_exists( '\LearnDash_Settings_Lessons_CPT' ) ) {
				$lesson_setting['learndash_settings_lessons_cpt'] = \LearnDash_Settings_Lessons_CPT::get_section_settings_all();
			}

			if ( class_exists( '\LearnDash_Settings_Lessons_Taxonomies' ) ) {
				$lesson_setting['learndash_settings_lessons_taxonomies'] = \LearnDash_Settings_Lessons_Taxonomies::get_section_settings_all();
			}

			return $lesson_setting;
		}

		/**
		 * Fetch topic global settings
		 *
		 * @return array
		 */
		public static function global_topic_settings() {
			$topic_setting = array();

			if ( class_exists( '\LearnDash_Settings_Topics_CPT' ) ) {
				$topic_setting['learndash_settings_topics_cpt'] = \LearnDash_Settings_Topics_CPT::get_section_settings_all();
			}

			if ( class_exists( '\LearnDash_Settings_Topics_Taxonomies' ) ) {
				$topic_setting['learndash_settings_topics_taxonomies'] = \LearnDash_Settings_Topics_Taxonomies::get_section_settings_all();
			}

			return $topic_setting;
		}

		/**
		 * Fetch quizzes global settings
		 *
		 * @return array
		 */
		public static function global_quizzes_settings() {
			$quizzes_setting = array();

			if ( class_exists( '\LearnDash_Settings_Quizzes_CPT' ) ) {
				$quizzes_setting['learndash_settings_quizzes_cpt'] = \LearnDash_Settings_Quizzes_CPT::get_section_settings_all();
			}

			if ( class_exists( '\LearnDash_Settings_Quizzes_Email' ) ) {
				$quizzes_setting['learndash_settings_quizzes_email'] = \LearnDash_Settings_Quizzes_Email::get_section_settings_all();
			}

			if ( class_exists( '\LearnDash_Settings_Quizzes_Management_Display' ) ) {
				$quizzes_setting['learndash_settings_quizzes_management_display'] = \LearnDash_Settings_Quizzes_Management_Display::get_section_settings_all();
			}

			if ( class_exists( '\LearnDash_Settings_Quizzes_Taxonomies' ) ) {
				$quizzes_setting['learndash_settings_quizzes_taxonomies'] = \LearnDash_Settings_Quizzes_Taxonomies::get_section_settings_all();
			}

			return $quizzes_setting;
		}

		/**
		 * Fetch questions global settings
		 *
		 * @return array
		 */
		public static function global_questions_settings() {
			$questions_setting = array();

			if ( class_exists( '\LearnDash_Settings_Questions_Taxonomies' ) ) {
				$questions_setting['learndash_settings_questions_taxonomies'] = \LearnDash_Settings_Questions_Taxonomies::get_section_settings_all();
			}

			if ( class_exists( '\LearnDash_Settings_Questions_Management_Display' ) ) {
				$questions_setting['learndash_settings_questions_management_display'] = \LearnDash_Settings_Questions_Management_Display::get_section_settings_all();
			}

			return $questions_setting;
		}

		/**
		 * Fetch certificates global settings
		 *
		 * @return array
		 */
		public static function global_certificates_settings() {
			$certificates_setting = array();

			if ( class_exists( '\LearnDash_Settings_Certificates_CPT' ) ) {
				$certificates_setting['learndash_settings_certificates_cpt'] = \LearnDash_Settings_Certificates_CPT::get_section_settings_all();
			}

			if ( class_exists( '\LearnDash_Settings_Certificates_Styles' ) ) {
				$certificates_setting['learndash_settings_certificates_styles'] = \LearnDash_Settings_Certificates_Styles::get_section_settings_all();
			}

			return $certificates_setting;
		}

		/**
		 * Fetch groups global settings
		 *
		 * @return array
		 */
		public static function global_groups_settings() {
			$groups_setting = array();

			if ( class_exists( '\LearnDash_Settings_Groups_CPT' ) ) {
				$groups_setting['learndash_settings_groups_cpt'] = \LearnDash_Settings_Groups_CPT::get_section_settings_all();
			}

			if ( class_exists( '\LearnDash_Settings_Section_Groups_Group_Leader_User' ) ) {
				$groups_setting['learndash_groups_group_leader_user'] = \LearnDash_Settings_Section_Groups_Group_Leader_User::get_section_settings_all();
			}

			if ( class_exists( '\LearnDash_Settings_Groups_Management_Display' ) ) {
				$groups_setting['learndash_settings_groups_management_display'] = \LearnDash_Settings_Groups_Management_Display::get_section_settings_all();
			}

			if ( class_exists( '\LearnDash_Settings_Groups_Membership' ) ) {
				$groups_setting['learndash_settings_groups_membership'] = \LearnDash_Settings_Groups_Membership::get_section_settings_all();
			}

			if ( class_exists( '\LearnDash_Settings_Groups_Taxonomies' ) ) {
				$groups_setting['learndash_settings_groups_taxonomies'] = \LearnDash_Settings_Groups_Taxonomies::get_section_settings_all();
			}

			return $groups_setting;
		}

		/**
		 * Fetch assignment global settings
		 *
		 * @return array
		 */
		public static function global_assignment_settings() {
			$assignment_setting = array();

			if ( class_exists( '\LearnDash_Settings_Assignments_CPT' ) ) {
				$assignment_setting['learndash_settings_assignments_cpt'] = \LearnDash_Settings_Assignments_CPT::get_section_settings_all();
			}

			return $assignment_setting;
		}
	}
}
