<?php
/**
 * LDIE admin page hook class
 *
 * @since 1.0.0
 * @package ea-import-export/admin/includes
 * Contributor: Jonatan Treviño
 */

namespace LDIE\Admin;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Ld_Admin_Page_Hook' ) ) {

	/**
	 * Ld_Admin_Page_Hook class
	 */
	class Ld_Admin_Page_Hook {


		/**
		 * Construct
		 */
		public function __construct() {
			add_action( 'ldie_select_to_process_html', [ $this, 'select_process' ], 10, 1 );
			add_action( 'ldie_associated_contents_html', [ $this, 'associated_contents' ], 10, 1 );
			add_action( 'ldie_global_contents_setting_html', [ $this, 'global_contents_setting' ], 10, 1 );
			add_action( 'ldie_opencourse_checkboxes_html', [ $this, 'opencourse_checkboxes_html' ], 10, 1 );
			add_action( 'ldie_buttons_html', [ $this, 'buttons' ], 10, 1 );
			add_action( 'ldie_radio_options_html', [ $this, 'data_types' ], 10, 1 );
			add_action( 'ldie_get_courses', [ $this, 'get_courses' ], 10, 1 );
			add_action( 'ldie_get_import_directories', [ $this, 'get_import_directories' ], 10, 1 );
		}

		/**
		 * Select Process
		 *
		 * @param Array $attr Attributes.
		 * @return void
		 */
		public function buttons( $attr = null ) {
			$allowed_html = [
				'input'  => [
					'name'  => [],
					'id'    => [],
					'class' => [],
					'type'  => [],
				],
				'button' => [
					'id'       => [],
					'class'    => [],
					'disabled' => [],
				],
			];

			$id          = md5( $attr['dataset'] );
			$class       = md5( $attr['dataset'] );
			$attr_id     = ( isset( $attr['id'] ) ) ? 'id="' . $attr['id'] . '"' : 'id="ldie_button_' . $id . '"';
			$attr_class  = ( isset( $attr['class'] ) ) ? 'class="' . $attr['class'] . '"' : 'class="ldie_buttons_' . $class . '"';
			$attr_name   = ( isset( $attr['name'] ) ) ? 'name="' . $attr['name'] . '"' : 'name="ldie_buttons_' . $class . '"';
			$is_disabled = ( isset( $attr['disabled'] ) ) ? $attr['disabled'] : false;

			if ( isset( $attr['file'] ) && $attr['file'] ) {
				$button = '<input type="file" ' . $attr_name . ' ' . $attr_id . ' ' . $attr_class . '>';
				echo wp_kses( apply_filters( 'ldie_admin_after_buttons', $button ), $allowed_html );
				return;
			}

			$button = '<button ' . $attr_id . ' ' . $attr_class . ' ' . ( $is_disabled ? 'disabled' : '' ) . '>' . $attr['dataset'] . '</button>';

			echo wp_kses( apply_filters( 'ldie_admin_after_buttons', $button ), $allowed_html );
		}

		/**
		 * Select Open Course data.
		 *
		 * @param Array $attr Attributes.
		 * @return void
		 */
		public function opencourse_checkboxes_html( $attr = null ) {
			$allowed_html = [
				'ul'    => [
					'id'    => [],
					'class' => [],
				],
				'p'     => [
					'class' => [],
				],
				'input' => [
					'type'    => [],
					'id'      => [],
					'class'   => [],
					'value'   => [],
					'name'    => [],
					'checked' => [],
				],
				'label' => [
					'for'   => [],
					'class' => [],
				],
			];

			$content = '';
			$ids     = 0;
			foreach ( $attr['dataset'] as $index => $val ) {
				if ( strlen( $index ) > 0 && 'sfwd-courses' !== $index ) {
					$content .= '<p class="ld-checkbox-input-wrapper">
						<input type="checkbox" id="ldie_ac_' . $index . '" class="ldie_ac_options learndash-section-field learndash-section-field-checkbox  ld-checkbox-input ' . $index . '_' . $attr['class'] . '" name="opencourse_checkboxes" value="' . $index . '" >
						<label for="ldie_ac_' . $index . '" class="ld-checkbox-input__label">' . $val . '</label>
					</p>';
				}
			}
			echo wp_kses( apply_filters( 'ldie_admin_after_opencourse_checkboxes_html', $content ), $allowed_html );
		}

		/**
		 * Select Process
		 *
		 * @param Array $attr Attributes.
		 * @return void
		 */
		public function global_contents_setting( $attr = null ) {
			$allowed_html = [
				'ul'    => [
					'id'    => [],
					'class' => [],
				],
				'p'     => [
					'class' => [],
				],
				'input' => [
					'type'    => [],
					'id'      => [],
					'class'   => [],
					'value'   => [],
					'name'    => [],
					'checked' => [],
				],
				'label' => [
					'for'   => [],
					'class' => [],
				],
			];

			$content = '';
			$ids     = 0;
			foreach ( $attr['dataset'] as $index => $val ) {
				if ( strlen( $index ) > 0 && 'sfwd-courses' !== $index ) {
					$content .= '<p class="ld-checkbox-input-wrapper">
						<input type="checkbox" id="ldie_ac_' . $index . '" class="ldie_ac_options learndash-section-field learndash-section-field-checkbox  ld-checkbox-input ' . $index . '_' . $attr['class'] . '" name="global_contents_setting" value="' . $index . '" >
						<label for="ldie_ac_' . $index . '" class="ld-checkbox-input__label">' . $val . '</label>
					</p>';
				}
			}

			echo wp_kses( apply_filters( 'ldie_admin_after_global_contents_setting', $content ), $allowed_html );
		}

		/**
		 * Select Process
		 *
		 * @param Array $attr Attributes.
		 * @return void
		 */
		public function associated_contents( $attr = null ) {
			$allowed_html = [
				'ul'    => [
					'id'    => [],
					'class' => [],
				],
				'p'     => [
					'class' => [],
				],
				'input' => [
					'type'    => [],
					'id'      => [],
					'class'   => [],
					'value'   => [],
					'name'    => [],
					'checked' => [],
				],
				'label' => [
					'for'   => [],
					'class' => [],
				],
			];

			$attr_id    = ( isset( $attr['id'] ) ) ? 'id="' . $attr['id'] . '"' : 'id="ldie_associated_content_id"';
			$attr_class = ( isset( $attr['class'] ) ) ? 'class="' . $attr['class'] . '"' : 'class="ldie_associated_content_class"';

			$content = '';
			$ids     = 0;
			foreach ( $attr['dataset'] as $index => $val ) {
				if ( strlen( $index ) > 0 && 'sfwd-courses' !== $index ) {
					$content .= '<p class="ld-checkbox-input-wrapper">
						<input type="checkbox" id="ldie_ac_' . $index . '" class="ldie_ac_options learndash-section-field learndash-section-field-checkbox  ld-checkbox-input ' . $index . '_' . $attr['class'] . '" name="post_type_associated" value="' . $index . '" >
						<label for="ldie_ac_' . $index . '" class="ld-checkbox-input__label">' . $val . '</label>
					</p>';
				}
			}

			echo wp_kses( apply_filters( 'ldie_admin_after_associated_content', $content ), $allowed_html );
		}

		/**
		 * Select Process
		 *
		 * @param Array $attr Attributes.
		 * @return void
		 */
		public function select_process( $attr = null ) {
			$allowed_html = [
				'select' => [
					'class' => [],
					'id'    => [],
					'name'  => [],
				],
				'option' => [
					'value'    => [],
					'selected' => [],
				],
			];

			$attr_id    = ( isset( $attr['id'] ) ) ? 'id="' . $attr['id'] . '"' : 'id="ldie_to_process"';
			$attr_class = ( isset( $attr['class'] ) ) ? 'class="' . $attr['class'] . '"' : 'class="ldie_to_process_class"';
			$attr_name  = ( isset( $attr['name'] ) ) ? 'name="' . $attr['name'] . '"' : 'name="ldie_to_process_name"';

			$select = '<select ' . $attr_id . ' ' . $attr_class . ' ' . $attr_name . ' >';

			$target  = apply_filters( 'ldie_admin_before_select_data', $attr['dataset'] );
			$options = '';
			foreach ( $target as $index => $text ) {
				$selected = ( strval( $index ) === $attr['default'] ) ? 'selected' : null;
				$options .= '<option value="' . $index . '" ' . $selected . '>' . $text . '</option>';
			}
			$select .= $options . '</select>';

			echo wp_kses( apply_filters( 'ldie_admin_after_select_data', $select ), $allowed_html );
		}

		/**
		 * Data Types selector
		 *
		 * @param Array $attr Attributes.
		 * @return void
		 */
		public function data_types( $attr = null ) {
			$allowed_html = [
				'input' => [
					'type'         => [],
					'id'           => [],
					'value'        => [],
					'name'         => [],
					'checked'      => [],
					'autocomplete' => [],
					'class'        => [],
				],
				'label' => [
					'class' => [],
					'for'   => [],
				],
				'div'   => [
					'id'    => [],
					'class' => [],
				],
				'p'     => [
					'class' => [],
				],
				'span'  => [],
			];
			$html         = '';
			foreach ( $attr['types'] as $value => $label ) {
				$html .= '<p id="' . $attr['id'] . '" class="ld-radio-input-wrapper">
				<input
				  autocomplete="off"
				  type="radio"
				  id="learndash_import_export_post_type_radio_' . $value . '_option"
				  name="' . $attr['name'] . '"
				  class="learndash-section-field learndash-section-field-radio  ld-radio-input"
				  value="' . $value . '"
				  ' . ( $value === $attr['value'] ? 'checked' : '' ) . '
				>
				<label
				  class="ld-radio-input__label"
				  for="learndash_import_export_post_type_radio_' . $value . '_option">
				  <span>' . $label . '</span>
				</label>
			</p>
			<p></p>';
			}

			echo wp_kses( apply_filters( 'ldie_admin_after_select_data_type', $html ), $allowed_html );
		}

		/**
		 * Data Types selector
		 *
		 * @param Array $attr Attributes.
		 * @return void
		 */
		public function get_courses( $attr = null ) {

			$args = [
				'posts_per_page' => -1,
				'post_type'      => 'sfwd-courses',
				'post_status'    => 'any',
			];

			$posts = get_posts( $args );

			$allowed_html = [
				'input' => [
					'type'         => [],
					'id'           => [],
					'value'        => [],
					'name'         => [],
					'checked'      => [],
					'autocomplete' => [],
					'class'        => [],
				],
				'label' => [
					'class' => [],
					'for'   => [],
				],
				'div'   => [
					'id'    => [],
					'class' => [],
				],
				'p'     => [
					'class'     => [],
					'data-name' => [],
				],
				'span'  => [],
			];
			$html         = '<div id="ldie-all-courses" class="ldie__export-per-course__container">';
			foreach ( $posts as $post ) {
				$html .= '<p class="ld-checkbox-input-wrapper" data-name="' . esc_attr( $post->post_title ) . '">
				<input
				  autocomplete="off"
				  type="checkbox"
				  id="learndash_import_export_post_id_' . $post->ID . '"
				  name="post_ids"
				  class="learndash-section-field learndash-section-field-checkbox  ld-checkbox-input"
				  value="' . $post->ID . '"
				>
				<label
				  class="ld-checkbox-input__label"
				  for="learndash_import_export_post_id_' . $post->ID . '">
				  <span>' . $post->post_title . '</span>
				  <span>(Status: ' . ucfirst( $post->post_status ) . ')</span>
				</label>
			</p>
			<p></p>';
			}
			$html .= '</div>';

			echo wp_kses( apply_filters( 'ldie_admin_after_select_data_type', $html ), $allowed_html );
		}

		/**
		 * Import Directory
		 *
		 * @param Array $attr Attributes.
		 * @return void
		 */
		public function get_import_directories( $attr = null ) {

			$directories = Ld_Admin_File_System::get_imported_directories();

			$allowed_html = [
				'input' => [
					'type'         => [],
					'id'           => [],
					'value'        => [],
					'name'         => [],
					'checked'      => [],
					'autocomplete' => [],
					'class'        => [],
				],
				'label' => [
					'class' => [],
					'for'   => [],
				],
				'div'   => [
					'id'    => [],
					'class' => [],
				],
				'p'     => [
					'class'     => [],
					'data-name' => [],
				],
				'span'  => [],
			];
			$html         = '<div>';

			if ( empty( $directories ) ) {
				$html .= '<p>' . esc_html__( 'There are no directories to import', 'ea_import_export' ) . '</p>';
			} else {

				foreach ( $directories as $dir ) {
					$html .= '<p class="ld-radio-input-wrapper" data-name="' . esc_attr( $dir ) . '">
					<input
					autocomplete="off"
					type="radio"
					id="learndash_import_export_post_id_' . $dir . '_radio"
					name="import_dir"
					class="learndash-section-field learndash-section-field-radio  ld-radio-input"
					value="' . $dir . '"
					>
					<label
					class="ld-radio-input__label"
					for="learndash_import_export_post_id_' . $dir . '_radio">
					<span>' . $dir . '</span>
					</label>
					</p>
					<p></p>';
				}
			}
			$html .= '</div>';

			echo wp_kses( apply_filters( 'ldie_admin_after_select_import_directories', $html ), $allowed_html );
		}
	}
}
