<?php
/**
 * LDIE admin main class
 *
 * @since 1.0.0
 * @package ea-import-export/admin/includes
 * Contributor: Jonatan Treviño
 */

namespace LDIE\Admin;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Ld_Admin' ) ) {

	/**
	 * Admin Main class.
	 */
	class Ld_Admin {


		/**
		 * Construct setup hooks and filters for admin
		 */
		public function __construct() {
			// call dl hook to add new tab in the DL menu!
			add_action( 'admin_menu', array( $this, 'admin_menu' ) );

			// add admin styles!
			add_action( 'admin_enqueue_scripts', array( $this, 'assets' ) );

			// add filters
			add_filter( 'action_scheduler_queue_runner_time_limit', array( $this, 'increase_time_limit' ) );

			new Ld_Admin_Export_File();
			new Ld_Admin_Import_File();
			new Ld_Admin_Reset_Data();
			new Ld_Admin_Page_Hook();
		}

		/**
		 * Assets
		 *
		 * @return void
		 */
		public function assets() {

			$screen = get_current_screen();

			if ( ! preg_match( '@learndash_lms_import__export@', $screen->id ) ) {
				return;
			}

			wp_enqueue_style( LDIE_PREFIX . '_admin_style', LDIE_PLUGIN_URL . 'admin/assets/style.css', array(), LDIE_VERSION );
			wp_enqueue_script(
				LDIE_PREFIX . '_admn_script',
				LDIE_PLUGIN_URL . 'admin/assets/app.js',
				array( 'jquery', 'wp-i18n' ),
				LDIE_VERSION,
				true
			);
			wp_set_script_translations( LDIE_PREFIX . '_admn_script', 'ea_import_export' );

			wp_localize_script(
				LDIE_PREFIX . '_admn_script',
				'ld_import_export',
				array(
					'ajax_url' => admin_url( 'admin-ajax.php' ),
				)
			);

		}

		/**
		 *
		 * Admin_menu
		 * call back action from admin_menu action hook to register submenu under learndash
		 *
		 * @since 1.0.0
		 */
		public function admin_menu() {

			if ( ! is_admin() || ! current_user_can( 'manage_options' ) ) {
				return;
			}

			add_submenu_page(
				'learndash-lms',
				__( 'Import Export', 'ea_import_export' ),
				__( 'Import Export', 'ea_import_export' ),
				'manage_options',
				'learndash_lms_import__export',
				array( $this, 'load_page' )
			);
		}

		/**
		 *
		 * Load_page
		 * call back action from admin_menu to render the admin page
		 *
		 * @since 1.0.0
		 */
		public function load_page() {
			$data = Ld_Text::text();
			include_once LDIE_PLUGIN_PATH . 'admin/templates/admin.php';
		}


		public function increase_time_limit( $time_limit ) {
			return 60;
		}
	}
}
