<?php
/**
 * LDIE admin text class
 *
 * @since 1.0.0
 * @package ea-import-export/admin/includes
 * Contributor: Jonatan Treviño
 */

namespace LDIE\Admin;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Ld_Text' ) ) {

	/**
	 * Admin Text helper.
	 */
	class Ld_Text {


		/**
		 * Undocumented function
		 *
		 * @param String $index key.
		 * @return Array
		 */
		public static function text( $index = null ) {
			$text_ = [
				'file'                   => [
					'error' => [
						0 => esc_html__( 'There is no error, the file uploaded with success', 'ea_import_export' ),
						1 => esc_html__( 'The uploaded file exceeds the upload_max_filesize directive in php.ini', 'ea_import_export' ),
						2 => esc_html__( 'The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form', 'ea_import_export' ),
						3 => esc_html__( 'The uploaded file was only partially uploaded', 'ea_import_export' ),
						4 => esc_html__( 'No file was uploaded', 'ea_import_export' ),
						6 => esc_html__( 'Missing a temporary folder', 'ea_import_export' ),
					],
				],
				'notices'                => [
					'nonce'   => esc_html__( 'Invalid nonce', 'ea_import_export' ),
					'status'  => [ esc_html__( 'failed', 'ea_import_export' ), esc_html__( 'success', 'ea_import_export' ) ],
					'failed'  => esc_html__( 'No respond is recorded', 'ea_import_export' ),
					'success' => esc_html__( 'Success', 'ea_import_export' ),
				],
				'title'                  => esc_html__( 'Import Export', 'ea_import_export' ),
				'buttons'                => [
					'import'  => esc_html__( 'Import', 'ea_import_export' ),
					'export'  => esc_html__( 'Export', 'ea_import_export' ),
					'proceed' => esc_html__( 'Proceed', 'ea_import_export' ),
				],
				'select_to_process'      => [
					'label'   => esc_html__( 'Post Type:', 'ea_import_export' ),
					'options' => [
						''                  => esc_html__( 'Select an option', 'ea_import_export' ),
						'sfwd-courses'      => esc_html__( 'Course', 'ea_import_export' ),
						'sfwd-lessons'      => esc_html__( 'Lessons', 'ea_import_export' ),
						'sfwd-topic'        => esc_html__( 'Topic', 'ea_import_export' ),
						'sfwd-quiz'         => esc_html__( 'Quiz', 'ea_import_export' ),
						'sfwd-question'     => esc_html__( 'Questions', 'ea_import_export' ),
						'sfwd-certificates' => esc_html__( 'Certificates', 'ea_import_export' ),
						'groups'            => esc_html__( 'Groups', 'ea_import_export' ),
						'sfwd-assignment'   => esc_html__( 'Assignments', 'ea_import_export' ),
					],
				],
				'content_global_setting' => [
					'label'   => esc_html__( 'Content Global Setting:', 'ea_import_export' ),
					'options' => [
						'sfwd-courses-setting'      => esc_html__( 'Course Settings', 'ea_import_export' ),
						'sfwd-lessons-setting'      => esc_html__( 'Lessons Settings', 'ea_import_export' ),
						'sfwd-topic-setting'        => esc_html__( 'Topic Settings', 'ea_import_export' ),
						'sfwd-quiz-setting'         => esc_html__( 'Quiz Settings', 'ea_import_export' ),
						'sfwd-question-setting'     => esc_html__( 'Questions Settings', 'ea_import_export' ),
						'sfwd-certificates-setting' => esc_html__( 'Certificates Settings', 'ea_import_export' ),
						'groups-setting'            => esc_html__( 'Groups Settings', 'ea_import_export' ),
						'sfwd-assignment-setting'   => esc_html__( 'Assignments Settings', 'ea_import_export' ),
					],
				],
				'open_course_data' => [
					'label'   => __( 'Do you want to export Open Course Users', 'ea_import_export' ),
					'options' => [
						'open-course-user-data' => __( 'Export Open Course User data', 'ea_import_export' ),
					],
				],
				'max_chunk'              => [
					'label'   => esc_html__( 'Max Chunk:', 'ea_import_export' ),
					'options' => [
						'50'  => '50',
						'100' => '100',
						'150' => '150',
						'200' => '200',
						'250' => '250',
						'500' => '500',
					],
				],
				'associated_label'       => esc_html__( 'Include associated content:', 'ea_import_export' ),
				'buttons'                => [
					'import'        => esc_html__( 'Import', 'ea_import_export' ),
					'export'        => esc_html__( 'Export', 'ea_import_export' ),
					'download_file' => esc_html__( 'Download File', 'ea_import_export' ),
					'reset'         => esc_html__( 'Reset', 'ea_import_export' ),
				],
				'associated_label'       => __( 'Include associated content:', 'ea_import_export' ),
				'post_type'              => [
					'courses'      => 'sfwd-courses',
					'lessons'      => 'sfwd-lessons',
					'topic'        => 'sfwd-topic',
					'quiz'         => 'sfwd-quiz',
					'questions'    => 'sfwd-question',
					'certificates' => 'sfwd-certificates',
					'groups'       => 'groups',
					'assignments'  => 'sfwd-assignment',
				],
			];

			if ( ! $index || ! array_key_exists( $index, $text_ ) ) {
				return apply_filters( 'dlie_global_text', $text_ );
			}

			return apply_filters( 'dlie_global_text', $text_[ $index ] );
		}
	}
}
