<?php
/**
 * Footer
 *
 * Main footer file for the theme.
 *
 * @package LearnDash-Importer-Exporter
 * @subpackage admin-template
 * @version 1.0.0
 * @author Jonatan Treviño <galtrev@gmail.com>

 * @since  1.0.0
 **/

?>

<div id="sfwd-header" class="ldie_head_panel">
	<h1>
		<?php echo esc_html( $data['title'] ); ?>
	</h1>
	<div class="ld-tab-buttons" id="ldie_export_tab">
		<a href="javascript:void(0);" class="ldie_button active" data-target-content="ldie_export_area"><?php echo esc_html( $data['buttons']['export'] ); ?></a>
		<a href="javascript:void(0);" class="ldie_button" data-target-content="ldie_import_area"><?php echo esc_html( $data['buttons']['import'] ); ?></a>
		<a href="javascript:void(0);" class="ldie_button" data-target-content="ldie_import_reset_area"><?php echo esc_html( $data['buttons']['reset'] ); ?></a>
	</div>
</div>
<div class="wrap ldie_panel">
	<h1 class="wp-heading-inline">
		<?php echo esc_html( $data['title'] ); ?>
	</h1>

	<div class="row">
		<div class="col">
			<div class="padd ldie_plug_content_wrap" id="ldie_export_area">
				<h2 class="heading__section-title"><?php esc_html_e( 'Export Data', 'ea_import_export' ); ?></h2>
				<form id="learndash_import_export_form_export">
					<?php wp_nonce_field( 'learndash_export_data', 'learndash_settings_import_export_nonce' ); ?>
					<div class="sfwd sfwd_options">
						<div id="" class="sfwd_input sfwd_input_type_radio">
							<span class="sfwd_option_label">
								<label for="learndash_import_export_data_type_radio" class="sfwd_label" style="text-align: left; float: left;">
								<?php esc_html_e( 'Data Type', 'ea_import_export' ); ?>
								</label>
								<div
									id="learndash_import_export_data_type_tip"
									class="sfwd_help_text_div"
								>
									<label class="sfwd_help_text"><?php esc_html_e( 'File extension', 'ea_import_export' ); ?>.</label>
								</div>
							</span>
							<span class="sfwd_option_input">
								<div class="sfwd_option_div">

									<fieldset>
										<legend class="screen-reader-text"><span><?php esc_html_e( 'Data Type', 'ea_import_export' ); ?></span></legend>
									</fieldset>
									<?php
									do_action(
										'ldie_radio_options_html',
										[
											'id'    => 'learndash_import_export_data_type_radio',
											'value' => 'json',
											'name'  => 'data_type',
											'types' => [
												'json' => 'JSON',
											],
										]
									);
									?>
								</div>
							</span>
						</div>
						<div id="" class="sfwd_input sfwd_input_type_select">
							<span class="sfwd_option_label">
								<label for="learndash_import_export_chunk_select" class="sfwd_label" style="text-align: left; float: left;">
								<?php esc_html_e( 'Max Chunk', 'ea_import_export' ); ?>
								</label>
								<div
									id="learndash_import_export_max_chunk_tip"
									class="sfwd_help_text_div"
								>
									<label class="sfwd_help_text"><?php esc_html_e( 'Set the maximum number of chunks per file, e.g: 150 chunks is 150 posts per file, use smaller numbers for less powerful servers.', 'ea_import_export' ); ?></label>
								</div>
							</span>
							<span class="sfwd_option_input">
								<div class="sfwd_option_div">
									<?php
									do_action(
										'ldie_select_to_process_html',
										[
											'id'      => 'learndash_import_export_chunk_select',
											'class'   => 'ldie_select_process widefat',
											'name'    => 'max_chunk_select',
											'dataset' => $data['max_chunk']['options'],
											'default' => '150',
										]
									);
									?>
								</div>
							</span>
						</div>
						<div id="" class="sfwd_input sfwd_input_type_select">
							<span class="sfwd_option_label">
								<label for="learndash_import_export_post_type_select" class="sfwd_label" style="text-align: left; float: left;">
								<?php esc_html_e( 'Post Type', 'ea_import_export' ); ?>
								</label>
							</span>
							<span class="sfwd_option_input">
								<div class="sfwd_option_div">
									<?php
									do_action(
										'ldie_select_to_process_html',
										[
											'id'      => 'learndash_import_export_post_type_select',
											'class'   => 'ldie_select_process widefat',
											'name'    => 'post_type_select',
											'dataset' => $data['select_to_process']['options'],
											'default' => '',
										]
									);
									?>
								</div>
							</span>
						</div>

						<div id="ldie_export_type" class="sfwd_input sfwd_input_type_radio" style="display:none;">
							<span class="sfwd_option_label">
								<label for="learndash_import_export_data_type_radio" class="sfwd_label" style="text-align: left; float: left;">
								<?php esc_html_e( 'Export Type', 'ea_import_export' ); ?>
								</label>
								<div
									id="learndash_import_export_data_type_tip"
									class="sfwd_help_text_div"
								>
									<label class="sfwd_help_text"></label>
								</div>
							</span>
							<span class="sfwd_option_input">
								<div class="sfwd_option_div">

									<fieldset>
										<legend class="screen-reader-text"><span><?php esc_html_e( 'Export Type', 'ea_import_export' ); ?></span></legend>
									</fieldset>
									<?php
									do_action(
										'ldie_radio_options_html',
										[
											'id'    => 'learndash_import_export_export_type_radio',
											'value' => 'all',
											'name'  => 'export_type',
											'types' => [
												'all' => __( 'All Courses', 'ea_import_export' ),
												'per-course' => __( 'Select Courses', 'ea_import_export' ),
											],
										]
									);
									?>
								</div>
							</span>
						</div>

						<div id="ldie_associated_content" class="sfwd_input sfwd_input_type_checkbox">
							<span class="sfwd_option_label">
								<label for="learndash_import_export_post_type_checkboxes" class="sfwd_label" style="text-align: left; float: left;">
								<?php echo esc_html( $data['associated_label'] ); ?>
								</label>
							</span>
							<span class="sfwd_option_input">
								<div class="sfwd_option_div">
									<?php
									do_action(
										'ldie_associated_contents_html',
										[
											'id'      => 'learndash_import_export_post_type_checkboxes',
											'class'   => 'ldie_associated_content_class',
											'dataset' => $data['select_to_process']['options'],
											'value'   => null,
										]
									);
									?>
								</div>
							</span>
						</div>

						<div id="ldie_courses_list" class="sfwd_input sfwd_input_type_checkbox" style="display:none;">
							<span class="sfwd_option_label">
								<label for="learndash_import_export_post_ids_checkboxes" class="sfwd_label" style="text-align: left; float: left;">
								<?php esc_html_e( 'Select Course', 'ea_import_export' ); ?>
								</label>
							</span>
							<span class="sfwd_option_input">
								<div class="sfwd_option_div">
									<span class="learndash_settings_field_text_prefix learndash-section-field learndash-section-field-text -medium ldie__search-course__input">
										<input type="text" placeholder="<?php esc_html_e( 'Search Course', 'ea_import_export' ); ?>" id="ldie-export-search-course" class="learndash-section-field learndash-section-field-text -medium" />
									</span>
									<?php
									do_action( 'ldie_get_courses' );
									?>
								</div>
							</span>
						</div>

						<div id="ldie_user_meta" class="sfwd_input sfwd_input_type_radio">
							<span class="sfwd_option_label">
								<label for="learndash_import_export_user_meta_radio" class="sfwd_label" style="text-align: left; float: left;">
									<?php esc_html_e( 'Users Data', 'learndash_import_export' ); ?>
								</label>
							</span>
							<span class="sfwd_option_input sfwd_option_input_user_data">
								<div class="sfwd_option_div">

									<fieldset>
										<legend class="screen-reader-text"><span><?php esc_html_e( 'Users Data', 'learndash_import_export' ); ?></span></legend>
									</fieldset>
									<?php
									do_action(
										'ldie_radio_options_html',
										[
											'id'    => 'learndash_import_export_user_meta_radio',
											'value' => 'yes',
											'name'  => 'user_meta',
											'types' => [
												'yes' => esc_html__( 'Yes', 'learndash_import_export' ),
												'no'  => esc_html__( 'No', 'learndash_import_export' ),
											],
										]
									);
									?>
								</div>
								<div class="sfwd_option_div sfwd_option_input_open_user_data">
									<p>--------------------------------</p>
									<?php
									do_action(
										'ldie_opencourse_checkboxes_html',
										[
											'id'      => 'ldie_opencourse_checkboxes',
											'class'   => 'ldie_opencourse_checkboxes_class',
											'dataset' => $data['open_course_data']['options'],
											'value'   => null,
										]
									);
									?>
								</div>
							</span>
						</div>

						<div id="ldie_content_global_setting" class="sfwd_input sfwd_input_type_checkbox">
							<span class="sfwd_option_label">
								<label for="learndash_import_export_global_content_setting_checkboxes" class="sfwd_label" style="text-align: left; float: left;">
								<?php echo esc_html( $data['content_global_setting']['label'] ); ?>
								</label>
							</span>
							<span class="sfwd_option_input">
								<div class="sfwd_option_div">
									<?php
									do_action(
										'ldie_global_contents_setting_html',
										[
											'id'      => 'ldie_global_content_setting_checkboxes',
											'class'   => 'ldie_content_global_setting_class',
											'dataset' => $data['content_global_setting']['options'],
											'value'   => null,
										]
									);
									?>
								</div>
							</span>
						</div>

						<p class="sfwd_input">
						<?php
						do_action(
							'ldie_buttons_html',
							[
								'id'       => 'ldie_export',
								'class'    => 'button button-primary button-large',
								'dataset'  => $data['buttons']['export'],
								'disabled' => true,
								'value'    => null,
								'file'     => false,
							]
						);
						?>
						</p>
					</div>
				</form>

				<hr/>

				<div id="ldie_exported_files">
					<h3><?php esc_html_e( 'Saved Exported files', 'ea_import_export' ); ?></h3>
					<div class="inline notice notice-warning notice-alt">
						<p>
						<?php esc_html_e( 'If the Zip File link is not available, You can search the path on your file system', 'ea_import_export' ); ?>
						</p>
					</div>
					<ul>
					</ul>
					<form id="ldie_export_delete_files_form">
					<?php wp_nonce_field( 'learndash_export_cleanup', 'learndash_settings_import_export_nonce' ); ?>
					<?php
						do_action(
							'ldie_buttons_html',
							[
								'id'      => 'ldie_export_delete_files',
								'class'   => 'button button-primary button-large',
								'dataset' => __( 'Clean Up', 'ea_import_export' ),
								'name'    => 'ldie_export_delete_files',
								'value'   => null,
							]
						);
						?>
					</form>
				</div>
			</div>

			<div class="padd ldie_plug_content_wrap" id="ldie_import_area">
				<h2 class="heading__section-title"><?php esc_html_e( 'Import Data', 'ea_import_export' ); ?></h2>
				<form id="learndash_import_export_form_import">
					<?php wp_nonce_field( 'learndash_import_data', 'learndash_settings_import_export_nonce' ); ?>
					<div class="sfwd sfwd_options ldie__import__options">

						<div id="" class="sfwd_input sfwd_input_type_radio">
							<span class="sfwd_option_label">
								<label for="ldie-import-type" class="sfwd_label" style="text-align: left; float: left;">
								<?php esc_html_e( 'Import Type', 'ea_import_export' ); ?>
								</label>
								<div
									id="learndash_import_export_data_type_tip"
									class="sfwd_help_text_div"
								>
									<label class="sfwd_help_text"><?php echo esc_html__( 'You can upload a Zip file, or upload the exported folder into', 'ea_import_export' ) . '<code>/wp-content/uploads/honorswp/import</code>' . esc_html__( 'directory.', 'ea_import_export' ); ?>  </label>
								</div>
							</span>
							<span class="sfwd_option_input">
								<div class="sfwd_option_div">

									<fieldset>
										<legend class="screen-reader-text"><span><?php esc_html_e( 'Import Type', 'ea_import_export' ); ?></span></legend>
									</fieldset>
									<?php
									do_action(
										'ldie_radio_options_html',
										[
											'id'    => 'ldie-import-type',
											'value' => 'zip',
											'name'  => 'import_type',
											'types' => [
												'zip' => esc_html__( 'Upload Zip file', 'ea_import_export' ),
												'dir' => esc_html__( 'Read directory from uploads', 'ea_import_export' ),
											],
										]
									);
									?>
								</div>
							</span>
						</div>

						<div id="" class="sfwd_input sfwd_input_type_radio">
							<span class="sfwd_option_label">
								<label for="ldie_is_slow_run" class="sfwd_label" style="text-align: left; float: left;">
								<?php esc_html_e( 'Optimize for Server', 'ea_import_export' ); ?>
								</label>
								<div
									id="learndash_import_export_is_slow_run_checkbox"
									class="sfwd_help_text_div"
								>
									<label class="sfwd_help_text"><?php esc_html_e( 'Will import the slowest possible to prevent Time out error, but it will take more time to import the data', 'ea_import_export' ); ?></label>
								</div>
							</span>
							<span class="sfwd_option_input">
								<div class="sfwd_option_div">

									<fieldset>
										<legend class="screen-reader-text"><span><?php esc_html_e( 'Optimize for Server', 'ea_import_export' ); ?></span></legend>
									</fieldset>
									<p class="ld-checkbox-input-wrapper">
										<input type="checkbox" id="ldie_is_slow_run" class="ldie_ac_options learndash-section-field learndash-section-field-checkbox  ld-checkbox-input ldie_is_slow_run_checkbox" name="is_slow_run" value="1" >
										<label for="ldie_is_slow_run" class="ld-checkbox-input__label"><?php esc_html_e( 'Slow Run', 'ea_import_export' ); ?></label>
									</p>
									<div id="ldie_slow_run_batch_input" style="display:none;" class="ld-number-input-wrapper">
										<div style="display: grid;max-width: 260px;">
											<input type="number" min="1" id="ldie_slow_run_batch" class="ldie_ac_options learndash-section-field learndash-section-field-number  ld-number-input ldie_slow_run_batch_number" name="slow_run_batch" value="1" >
											<label for="ldie_slow_run_batch" class="sfwd_help_text"><?php esc_html_e( 'The lower the batch, slower the process but safest. Recommended: 10', 'ea_import_export' ); ?></label>
										</div>
									</div>
								</div>
							</span>
						</div>

						<div id="ldie-import-zip-uploader" class="sfwd_input sfwd_input_type_select">
							<span class="sfwd_option_label">
								<label for="learndash_import_export_post_type_select" class="sfwd_label" style="text-align: left; float: left;">
								<?php esc_html_e( 'File to Import:', 'ea_import_export' ); ?>
								</label>
							</span>
							<span class="sfwd_option_input">
								<div class="sfwd_option_div">
									<?php
									do_action(
										'ldie_buttons_html',
										[
											'id'      => 'ldie_import_file',
											'class'   => 'ldie_import_file_field',
											'dataset' => '',
											'file'    => true,
											'name'    => 'ldie_import_file',
											'value'   => null,
										]
									);
									?>
								</div>
							</span>
						</div>

						<div id="ldie-import-uploads-dir" class="sfwd_input sfwd_input_type_checkbox" style="display:none;">
							<span class="sfwd_option_label">
								<label class="sfwd_label" style="text-align: left; float: left;">
								<?php esc_html_e( 'Select Folder to Import', 'ea_import_export' ); ?>
								</label>
								<div
									id="learndash_import_export_data_type_tip"
									class="sfwd_help_text_div"
								>
									<label class="sfwd_help_text"><?php esc_html_e( 'Once the directory is imported, will be deleted to avoid usage of storage directory. The data to import must be decompressed and stored as directory', 'ea_import_export' ); ?></label>
								</div>
							</span>
							<span class="sfwd_option_input">
								<div class="sfwd_option_div">
								<?php
								do_action( 'ldie_get_import_directories' );
								?>
								</div>
							</span>
						</div>

						<div id="ldie__process" style="display:none;">
							<ul class="ldie__process__list">
								<li class="ldie__process__item">
									<div class="ldie__process__content ldie__process__content--is-head">
										<span><?php esc_html_e( 'Process', 'ea_import_export' ); ?></span> <span><?php esc_html_e( 'Status', 'ea_import_export' ); ?></span>
									</div>
								</li>
								<li class="ldie__process__item" id="ldie_analyze">
									<div class="ldie__process__content">
										<span class="ldie__process__title"><?php esc_html_e( 'Analizing Files and Imported data', 'ea_import_export' ); ?> ( <span data-imported>0</span> <?php esc_html_e( 'of', 'ea_import_export' ); ?> <span data-to-import>0</span> <?php esc_html_e( 'files', 'ea_import_export' ); ?>) ...</span>
										<span class="ldie__status ldie__status__loading"><?php esc_html_e( 'Pending', 'ea_import_export' ); ?></span>
									</div>
								</li>
								<li class="ldie__process__item" id="ldie_global_settings">
									<div class="ldie__process__content">
										<span class="ldie__process__title"><?php esc_html_e( 'Importing Learndash Settings', 'ea_import_export' ); ?> ( <span data-imported>0</span> <?php esc_html_e( 'of', 'ea_import_export' ); ?> <span data-to-import>0</span> <?php esc_html_e( 'settings', 'ea_import_export' ); ?>) ...</span>
										<span class="ldie__status ldie__status__loading"><?php esc_html_e( 'Pending', 'ea_import_export' ); ?></span>
										<button type="button" class="ldie__button__details"><?php esc_html_e( 'Show More Details', 'ea_import_export' ); ?></button>
									</div>
									<div class="ldie__details ldie__details--is-hidden">
										<div><span><?php esc_html_e( 'File', 'ea_import_export' ); ?></span> <span><?php esc_html_e( 'Status', 'ea_import_export' ); ?></span></div>
									</div>
								</li>
								<li class="ldie__process__item" id="ldie_users_data">
									<div class="ldie__process__content">
										<span class="ldie__process__title"><?php esc_html_e( 'Importing Users data', 'learndash_import_export' ); ?> ( <span data-imported>0</span> <?php esc_html_e( 'of', 'learndash_import_export' ); ?> <span data-to-import>0</span> <?php esc_html_e( 'Users', 'learndash_import_export' ); ?>) ...</span>
										<span class="ldie__status ldie__status__loading"><?php esc_html_e( 'Pending', 'learndash_import_export' ); ?></span>
										<button type="button" class="ldie__button__details"><?php esc_html_e( 'Show More Details', 'learndash_import_export' ); ?></button>
									</div>
									<div class="ldie__details ldie__details--is-hidden">
										<div><span><?php esc_html_e( 'File', 'learndash_import_export' ); ?></span> <span><?php esc_html_e( 'Status', 'learndash_import_export' ); ?></span></div>
									</div>
								</li>
								<li class="ldie__process__item" id="ldie_categories">
									<div class="ldie__process__content">
										<span class="ldie__process__title"><?php esc_html_e( 'Importing WP Categories', 'ea_import_export' ); ?> ( <span data-imported>0</span> <?php esc_html_e( 'of', 'ea_import_export' ); ?> <span data-to-import>0</span> <?php esc_html_e( 'categories', 'ea_import_export' ); ?>) ...</span>
										<span class="ldie__status ldie__status__loading"><?php esc_html_e( 'Pending', 'ea_import_export' ); ?></span>
										<button type="button" class="ldie__button__details"><?php esc_html_e( 'Show More Details', 'ea_import_export' ); ?></button>
									</div>
									<div class="ldie__details ldie__details--is-hidden">
										<div><span><?php esc_html_e( 'File', 'ea_import_export' ); ?></span> <span><?php esc_html_e( 'Status', 'ea_import_export' ); ?></span></div>
									</div>
								</li>
								<li class="ldie__process__item" id="ldie_quiz_pro">
									<div class="ldie__process__content">
										<span class="ldie__process__title"><?php esc_html_e( 'Importing Quiz Pro data', 'ea_import_export' ); ?> ( <span data-imported>0</span> <?php esc_html_e( 'of', 'ea_import_export' ); ?> <span data-to-import>0</span> <?php esc_html_e( 'questions', 'ea_import_export' ); ?>) ...</span>
										<span class="ldie__status ldie__status__loading"><?php esc_html_e( 'Pending', 'ea_import_export' ); ?></span>
										<button type="button" class="ldie__button__details"><?php esc_html_e( 'Show More Details', 'ea_import_export' ); ?></button>
									</div>
									<div class="ldie__details ldie__details--is-hidden">
										<div><span><?php esc_html_e( 'File', 'ea_import_export' ); ?></span> <span><?php esc_html_e( 'Status', 'ea_import_export' ); ?></span></div>
									</div>
								</li>
								<li class="ldie__process__item" id="ldie_posts">
									<div class="ldie__process__content">
										<span class="ldie__process__title"><?php esc_html_e( 'Importing Posts', 'ea_import_export' ); ?> ( <span data-imported>0</span> <?php esc_html_e( 'of', 'ea_import_export' ); ?> <span data-to-import>0</span> <?php esc_html_e( 'posts', 'ea_import_export' ); ?>) ...</span>
										<span class="ldie__status ldie__status__loading"><?php esc_html_e( 'Pending', 'ea_import_export' ); ?></span>
										<button type="button" class="ldie__button__details"><?php esc_html_e( 'Show More Details', 'ea_import_export' ); ?></button>
									</div>
									<div class="ldie__details ldie__details--is-hidden">
										<div><span><?php esc_html_e( 'File', 'ea_import_export' ); ?></span> <span><?php esc_html_e( 'Status', 'ea_import_export' ); ?></span></div>
									</div>
								</li>
								<li class="ldie__process__item" id="ldie_mapper">
									<div class="ldie__process__content">
										<span class="ldie__process__title"><?php esc_html_e( 'Mapping Old posts with New posts', 'ea_import_export' ); ?> ( <span data-imported>0</span> <?php esc_html_e( 'of', 'ea_import_export' ); ?> <span data-to-import>0</span> <?php esc_html_e( 'posts', 'ea_import_export' ); ?>) ...</span>
										<span class="ldie__status ldie__status__loading"><?php esc_html_e( 'Pending', 'ea_import_export' ); ?></span>
									</div>
								</li>
								<li class="ldie__process__item" id="ldie_user_mapper">
									<div class="ldie__process__content">
										<span class="ldie__process__title"><?php esc_html_e( 'Mapping Old users with New users', 'learndash_import_export' ); ?> ( <span data-imported>0</span> <?php esc_html_e( 'of', 'learndash_import_export' ); ?> <span data-to-import>0</span> <?php esc_html_e( 'users', 'learndash_import_export' ); ?>) ...</span>
										<span class="ldie__status ldie__status__loading"><?php esc_html_e( 'Pending', 'learndash_import_export' ); ?></span>
									</div>
								</li>
							</ul>
						</div>

						<p class="sfwd_input">
							<?php
							do_action(
								'ldie_buttons_html',
								[
									'id'      => 'ldie_import',
									'class'   => 'button button-primary button-large',
									'dataset' => $data['buttons']['import'],
									'value'   => null,
									'file'    => false,
								]
							);
							?>
						</p>
					</div>
				</form>
			</div>

			<div class="padd ldie_plug_content_wrap" id="ldie_import_reset_area">
				<h2 class="heading__section-title"><?php esc_html_e( 'Reset Data', 'ea_import_export' ); ?></h2>
				<form id="learndash_import_export_form_reset">
					<?php wp_nonce_field( 'learndash_reset_data', 'learndash_settings_import_export_nonce' ); ?>
					<div class="inline notice notice-error notice-alt">
						<p>
						<?php esc_html_e( 'This will delete ALL LearnDash data. It is permanent and not reversable. Back up your database before taking this action.', 'ea_import_export' ); ?>
						</p>
					</div>
					<?php
					do_action(
						'ldie_buttons_html',
						[
							'id'      => 'ldie_reset',
							'class'   => 'button button-primary button-large',
							'dataset' => $data['buttons']['reset'],
							'value'   => null,
							'file'    => false,
						]
					);
					?>
				</form>
			</div>

		</div>
	</div>
</div>
