<?php
/**
 * Plugin Name:       Import & Export Tool for LearnDash
 * Plugin URI:        https://honorswp.com/plugins/import-export-tool-for-learndash/
 * Description:       Easily export your courses from one LearnDash site and import them into another.
 * Version:           1.4.2
 * Requires PHP:      7.4
 * Requires at least: 5.8
 * Author:            Honors WP
 * Author URI:        honorswp.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       ea_import_export
 *
 * @package ea-import-export
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use EA\Licensing\License;

require_once __DIR__ . '/vendor/autoload.php';

/**
 * Define Constant Variable
 *
 * @since 1.0.0
 * @package ea-import-export
 * */
define( 'LDIE_VERSION', '1.4.2' );
define( 'LDIE_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
define( 'LDIE_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'LDIE_PLUGIN_FILE', dirname( __FILE__ ) );
define( 'LDIE_PLUGIN_DIR', trailingslashit( str_replace( '\\', '/', WP_PLUGIN_DIR ) . '/' . basename( dirname( __FILE__ ) ) ) );
define( 'LDIE_PREFIX', 'ldie' );

/**
 * Licensing
 */
new License(
	esc_html__( 'Importer & Exporter Tool for LearnDash', 'ea_import_export' ),
	6511,
	'learndash-importer-exporter',
	__FILE__,
	LDIE_VERSION,
);

/**
 * Will check Learndash plugin is activate or not.
 *
 * @since 1.0.0
 * @package ea-import-export
 * **/
function ldie_install() {

	if ( ! current_user_can( 'activate_plugins' ) ) {
		return;
	}

	if ( class_exists( 'SFWD_LMS' ) ) {
		return;
	}

	// Leave message if the required plugin is not available.
	add_action( 'admin_notices', 'ldie_fail_load' );
	add_action( 'network_admin_notices', 'ldie_fail_load' );
}
add_action( 'plugins_loaded', 'ldie_install' );

/**
 * Check if Learndash is available or not.
 *
 * @since X.X.X
 * @package ea-import-export
 *
 * @return boolean
 */
function ldie_is_learndash_available() {
	$file_path         = 'sfwd-lms/sfwd_lms.php';
	$installed_plugins = get_plugins();
	return isset( $installed_plugins[ $file_path ] );
}

/**
 * Show warning to install learndash.
 *
 * @since X.X.X
 * @package ea-import-export
 *
 * @return void
 */
function ldie_fail_load() {
	$plugin = 'sfwd-lms/sfwd_lms.php';

	if ( ldie_is_learndash_available() ) {
		$activation_url = wp_nonce_url( 'plugins.php?action=activate&amp;plugin=' . $plugin . '&amp;plugin_status=all&amp;paged=1&amp;s', 'activate-plugin_' . $plugin );
		$message        = esc_html__( '<strong>Import & Export Tool for LearnDash</strong> requires <strong> Learndash </strong> plugin to be active. Please activate Learndash to continue.', 'ea_import_export' );
		$button_text    = esc_html__( 'Activate Import & Export Tool for LearnDash', 'ea_import_export' );
		$button         = '<p><a href="' . esc_url( $activation_url ) . '" class="button-primary">' . esc_html( $button_text ) . '</a></p>';

		printf( '<div class="notice notice-error"><p>%1$s</p>%2$s</div>', wp_kses_post( $message ), wp_kses_post( $button ) );
	} else {
		$message = esc_html__( 'Please install <strong>Learndash</strong> before using <strong>Import & Export Tool for LearnDash</strong>.', 'ea_import_export' );
		printf( '<div class="notice notice-error"><p>%1$s</p></div>', wp_kses_post( $message ) );
	}
}

require_once dirname( __FILE__ ) . '/admin/includes/class-ld-admin.php';

require_once dirname( __FILE__ ) . '/admin/includes/class-ld-text.php';

require_once dirname( __FILE__ ) . '/admin/includes/class-ld-admin-global-content-setting.php';

require_once dirname( __FILE__ ) . '/admin/includes/class-ld-admin-export-media.php';

require_once dirname( __FILE__ ) . '/admin/includes/class-ld-admin-export-data.php';

require_once dirname( __FILE__ ) . '/admin/includes/class-ld-admin-export-file-all-data.php';

require_once dirname( __FILE__ ) . '/admin/includes/class-ld-admin-export-file-per-course.php';

require_once dirname( __FILE__ ) . '/admin/includes/class-ld-admin-export-file.php';

require_once dirname( __FILE__ ) . '/admin/includes/class-ld-admin-export-json-file.php';

require_once dirname( __FILE__ ) . '/admin/includes/class-ld-admin-export-xml-file.php';

require_once dirname( __FILE__ ) . '/admin/includes/class-ld-admin-file-system.php';

require_once dirname( __FILE__ ) . '/admin/includes/class-ld-admin-import-common-file.php';

require_once dirname( __FILE__ ) . '/admin/includes/class-ld-admin-import-abstract-file.php';

require_once dirname( __FILE__ ) . '/admin/includes/class-ld-admin-import-process-actions.php';

require_once dirname( __FILE__ ) . '/admin/includes/class-ld-admin-import-file.php';

require_once dirname( __FILE__ ) . '/admin/includes/class-ld-admin-import-json-file.php';

require_once dirname( __FILE__ ) . '/admin/includes/class-ld-admin-import-xml-file.php';

require_once dirname( __FILE__ ) . '/admin/includes/class-ld-admin-page-hook.php';

require_once dirname( __FILE__ ) . '/admin/includes/class-ld-admin-reset-data.php';

require_once dirname( __FILE__ ) . '/vendor/woocommerce/action-scheduler/action-scheduler.php';

/**
 * Load admin class after the plugin initialized and loaded
 *
 * @since 1.0.0
 * @package ea-import-export
 * @return void
 */
function ldie_init_plugin() {
	if ( ! is_admin() ) {
		return;
	}

	new LDIE\Admin\Ld_Admin();
}

add_action( 'init', 'ldie_init_plugin' );

/**
 * Load the plugin text domain for translation.
 */
function ldie_load_plugin_textdomain() {
	load_plugin_textdomain(
		'ea_import_export',
		false,
		dirname( plugin_basename( __FILE__ ) ) . '/languages/'
	);
}

add_action( 'init', 'ldie_load_plugin_textdomain' );
