<?php
/**
 * This file is used to include the class which does the functionality for import export.
 *
 * @package RatingsReviewsFeedback\Admin\import-export
 */

/**
 * Import-export class
 */
class Course_Review_Import_Export {
	/**
	 * Instance of this class.
	 *
	 * @var object
	 */
	protected static $instance = null;
	/**
	 * Constructor
	 */
	public function __construct() {

		add_action( 'admin_enqueue_scripts', array( $this, 'enq_scripts_styles' ) );
		add_action( 'wp_ajax_export_form', array( $this, 'get_array_of_posts_id_for_export' ) );
		add_action( 'wp_ajax_create_csv_export', array( $this, 'ajax_export_reviews_to_csv' ) );

	}
	/**
	 * Returns an instance of this class.
	 *
	 * @return object A single instance of this class.
	 */
	public static function get_instance() {
		// If the single instance hasn't been set, set it now.
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}
	/**
	 * [enq_scripts_styles description]
	 */
	public function enq_scripts_styles() {
		$upload        = wp_upload_dir();

		wp_enqueue_script( 'wdm-io-addon-multiselect-js', plugins_url( 'admin/js/jquery.multiselect.js', RRF_PLUGIN_FILE ), array( 'jquery' ), WDM_LD_COURSE_VERSION, true );
		wp_enqueue_script( 'wdm-io-addon-csvx`-js', plugins_url( 'admin/js/jquery.csv.js', RRF_PLUGIN_FILE ), array( 'jquery' ), WDM_LD_COURSE_VERSION, true );
		wp_enqueue_style( 'jquery-ui-miltiselect', plugins_url( 'admin/css/jquery.multiselect.css', RRF_PLUGIN_FILE ), array(), WDM_LD_COURSE_VERSION );
		wp_enqueue_style( 'jquery-ui', plugins_url( 'admin/css/jquery-ui.css', RRF_PLUGIN_FILE ), array(), WDM_LD_COURSE_VERSION );
		wp_register_script( 'wdm-io-addon-import-export-js', plugins_url( 'admin/js/admin-import-export.js', RRF_PLUGIN_FILE ), array( 'jquery', 'jquery-ui-datepicker' ), WDM_LD_COURSE_VERSION, true );
		wp_localize_script(
			'wdm-io-addon-import-export-js',
			'ajax_object',
			array(
				'ajax_url'   => admin_url( 'admin-ajax.php' ),
				'loader_url' => plugins_url( 'admin/images/loader.gif', RRF_PLUGIN_FILE ),
				'csv_url'	 => $upload['baseurl'] . '/rrf_export_file/reviews.csv',
			)
		);
		wp_enqueue_script( 'wdm-io-addon-import-export-js' );

	}

	/**
	 * This function call in succesive ajax call on export form submit to add reviews in bulk of 30.
	 */
	public function ajax_export_reviews_to_csv() {

		check_ajax_referer( 'wdm_review_setting_export_nonce', 'security', true );

		$post_id_array = isset( $_POST['post_ids'] ) ? (array) $_POST['post_ids'] : array();
		$upload        = wp_upload_dir();
		if ( ! file_exists( $upload['basedir'] . '/rrf_export_file' ) ) {
			mkdir( $upload['basedir'] . '/rrf_export_file' );
		}
		// @codingStandardsIgnoreLine
		$file = fopen( $upload['basedir'] . '/rrf_export_file/reviews.csv', 'a' );
		if ( ! empty( $post_id_array ) ) {
			foreach ( $post_id_array as $key => $value ) {

				$post_data      = get_post( $value, ARRAY_A );
				$post_meta_data = get_post_meta( $value, 'wdm_course_review_review_on_course', true );
				$review_course  = get_the_title( $post_meta_data );
				$review_author  = get_userdata( $post_data['post_author'] );
				$putcsv_data   = array();
				$putcsv_data[] = $review_course;
				$putcsv_data[] = $post_data['post_title'];
				$putcsv_data[] = $post_data['post_content'];
				$putcsv_data[] = get_post_meta( $value, 'wdm_course_review_review_rating', true );
				$putcsv_data[] = $post_data['post_author'];
				$putcsv_data[] = $review_author->user_email;
				$putcsv_data[] = $review_author->first_name;
				$putcsv_data[] = $review_author->last_name;

				fputcsv( $file, $putcsv_data );
				/* translators: review title, course, autor of review */
			}
		}
		// @codingStandardsIgnoreLine
		fclose( $file );
		die();
	}
	/**
	 * [ajax_export_form_submit description]
	 */
	public function get_array_of_posts_id_for_export() {
		// Its for devlopment use to make sure file not get appended every time.
		check_ajax_referer( 'wdm_review_setting_export_nonce', 'security', true );

		$upload = wp_upload_dir();
		if ( file_exists( $upload['basedir'] . '/rrf_export_file/reviews.csv' ) ) {
			@unlink( $upload['basedir'] . '/rrf_export_file/reviews.csv' );
		}
		// @codingStandardsIgnoreLine
		$file = fopen( $upload['basedir'] . '/rrf_export_file/reviews.csv', 'w' );
		fputcsv( $file, array( 'Course Title', 'Review Title', 'description', 'Rating', 'Author', 'Email Id', 'First Name', 'Last Name' ) );
		// @codingStandardsIgnoreLine
		fclose($file);

		$export_conditions                    = array();
		$export_conditions['course_dropdown'] = isset( $_POST['course_dropdown'] ) ? (array) $_POST['course_dropdown'] : array();
		// Main array for posts.
		$args             = array(
			'post_type'   => 'wdm_course_review',
			'numberposts' => -1,
		);
		$meta_value_array = array();
		// if metavalues are given.
		// is_array( $export_conditions['course_dropdown'] ).

		// This varibale gets all posrt with date and authos condition.
		$current_posts = get_posts( $args );
		$posts         = array();
		if ( ! empty( $current_posts ) ) {
			foreach ( $current_posts as $post_without_meta ) {

				// This gets course and rating count related to review post.
				$post_meta_array = get_post_meta( $post_without_meta->ID );

				// This vaibale used to check if metavalue condition matches or not.
				$meta_value_condition_var = true;

				if ( ! in_array( $post_meta_array['wdm_course_review_review_on_course'][0], $export_conditions['course_dropdown'], true ) && ( ! empty( $export_conditions['course_dropdown'] ) ) ) {
					$meta_value_condition_var = false;
				}
				if ( $meta_value_condition_var ) {
					$posts[] = $post_without_meta->ID;
				}
			}
		}
		// This is set to 5 as now revires are less.
		$post_chunk = array_chunk( $posts, 30 );
		wp_send_json( $post_chunk );
		die();
	}
}
Course_Review_Import_Export::get_instance();
