<?php
$courses_left = get_posts(
	array(
		'post_type'   => 'sfwd-courses',
		'post_status' => 'publish',
		'numberposts' => 10,
		'fields' => 'ids',
		'meta_query' => array(
			'relation' => 'OR',
	        array(
	            'key'   => 'is_ratings_enabled',
	            'value' => 'yes',
	        ),
	        array(
	            'key'   => 'is_ratings_enabled',
	            'value' => 'global',
	        )
	    )
	)
);
$courses_right = get_posts(
	array(
		'post_type'   => 'sfwd-courses',
		'post_status' => 'publish',
		'numberposts' => 10,
		'fields' => 'ids',
		'meta_query' => array(
			'relation' => 'OR',
	        array(
	            'key'     => 'is_ratings_enabled',
	            'compare' => 'NOT EXISTS',
	            'value'   => '',
	        ),
	        array(
	            'key'     => 'is_ratings_enabled',
	            'value'   => 'no',
	        ),
	    )
	)
);
?>
<div class="cpb_dual_list options_group">
	<div class="dual-flex">
		<div class="left">
			<!-- <input type="search" name="left-search" class="search cpb-no-submit" placeholder="Start typing..."> -->
			<label><strong><?php echo esc_html__( 'Course Reviews Enabled', 'wdm_ld_course_review' );?></strong></label>
			<ul class="select">
				<?php foreach ( $courses_left as $course_id ) : ?>
					<li data-id="<?php echo esc_attr( $course_id ); ?>"><?php echo get_the_title( $course_id ); ?></li>
				<?php endforeach; ?>
			</ul>
			<div class="left-pagination">
				<ul class="pagination"></ul>
			</div>
		</div>
		<div class="right">
			<!-- <input type="search" name="right-search" class="search cpb-no-submit" placeholder="Start typing..."> -->
			<label><strong><?php echo esc_html__( 'Course Reviews Disabled', 'wdm_ld_course_review' );?></strong></label>
			<ul class="select">
				<?php foreach ( $courses_right as $course_id ) : ?>
					<li data-id="<?php echo esc_attr( $course_id ); ?>"><?php echo get_the_title( $course_id ); ?></li>
				<?php endforeach; ?>
			</ul>
			<input type="hidden" name="cpb_selected_items" class="cpb_selected_items" value="<?php echo esc_attr( json_encode( $courses_right ) ); ?>">
		</div>
	</div>
</div>