<?php
/**
 * Plugin Name: Dual List
 * Plugin URI: 
 * Description: 
 * Version: 1.0.0
 * Author: 
 * Author URI: 
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
function dual_options_group() {
	ob_start();
	include 'dual-list-template.php';
	echo ob_get_clean();
}
add_action( 'rrf_add_global_control_reviews', 'dual_options_group' );


add_action( 'admin_enqueue_scripts', 'enqueue_admin_js' );
function enqueue_admin_js() {

	$js_ver  = filemtime( plugin_dir_path( __FILE__ ) . 'js/dual-list.js' );
	$css_ver = filemtime( plugin_dir_path( __FILE__ ) . 'css/dual-list.css' );

	wp_enqueue_script( 'dual-script', plugins_url( 'js/dual-list.js', __FILE__ ), array( 'jquery' ), $js_ver );
	wp_register_style( 'dual-css',    plugins_url( 'css/dual-list.css', __FILE__ ), false,   $css_ver );
	wp_enqueue_style ( 'dual-css' );

	$localized_data = array(
		'leftOptLabel' => __( 'Recently Enabled', 'wdm_ld_course_review' ),
		'rightOptLabel' => __( 'Recently Disabled', 'wdm_ld_course_review' ),
		'emptyLi' => '<li data-id="#id#">#title#</li>',
		'liReplace' => array(
			'id' => '#id#',
			'title' => '#title#'
		),
		'ajaxurl' => admin_url( 'admin-ajax.php' ),
		'nonce' => wp_create_nonce( 'cpb-admin-add-on-search-ajax-' . get_current_user_id() ),
		'ajaxActionName' => 'cpb-admin-search-addons',
		'dataLoadingString' => __( 'Loading...', 'wdm_ld_course_review' ),
		'noDataFoundString' => __( 'Course not found', 'wdm_ld_course_review' ),
		'dataLoadingErrorString' => __( 'Error in loading courses.', 'wdm_ld_course_review' )
	);
	wp_localize_script( 'dual-script', 'dualListObj', $localized_data );
}


add_action( 'wp_ajax_cpb-admin-search-addons', 'cpb_admin_search_addons_cb' );
function cpb_admin_search_addons_cb() {

	$page = isset( $_POST['page'] ) ? ( int ) $_POST['page'] : 1;
	$limit = 2;
	$query = isset( $_POST['query'] ) ? trim( $_POST['query'] ) : '';

	$offset = ( $page - 1 ) * $limit;
	$courses_left = get_posts(
		array(
			'post_type'   => 'sfwd-courses',
			'post_status' => 'publish',
			'numberposts' => 10,
			'fields' => 'ids',
			'offset'   => $page * 10,
			'meta_query' => array(
				'relation' => 'OR',
		        array(
		            'key'   => 'is_ratings_enabled',
		            'value' => 'yes',
		        ),
		        array(
		            'key'   => 'is_ratings_enabled',
		            'value' => 'global',
		        )
		    )
		)
	);
	$products = array();
	if ( '' !== $query ) {
		$searched_array = array();
		$counter = 0;
		foreach( $products as $prod_id => $product_title ) {
			if ( $counter === $limit ) {
				break;
			}
			if ( strpos( strtolower( $product_title ), strtolower( $query ) ) !== FALSE ) {
				$searched_array[ $prod_id ] = $product_title;
				$counter++;
			}
		}
		$products = $searched_array;
	} else {
		// $products = array_slice( $products, 0, $limit, true );
	}


	$key_val_products = array();
	$index = 0;
	foreach ( $courses_left as $course_id ) {
		$key_val_products[ $index ]['id'] = $course_id;
		$key_val_products[ $index ]['title'] = get_the_title( $course_id );
		$index++;
	}
	wp_send_json( $key_val_products );
}

add_action( 'wp_ajax_disable_course_review', 'rrf_disable_course_review' );
function rrf_disable_course_review() {
	$courses = json_decode( $_POST[ 'courses' ] );
	foreach ( $courses as $course_id ) {
		update_post_meta( $course_id, 'is_ratings_enabled', 'no' );
	}
}

add_action( 'wp_ajax_enable_course_review', 'rrf_enable_course_review' );
function rrf_enable_course_review() {
	$courses = json_decode( $_POST[ 'courses' ] );
	foreach ( $courses as $course_id ) {
		update_post_meta( $course_id, 'is_ratings_enabled', 'yes' );
	}
}
