(function($) {
	$.cpbDualList = function( element ) {

		/*
		|
		| Global elements
		|
		*/
		var dualList     = this;
		var $container   = $( element );

		// Left item box.
		var $leftBox     = $container.find( '.left' );
		var $leftSelect  = $leftBox.find( '.select' );
		var $leftSearch  = $leftBox.find( '.search' );

		// Right item box.
		var $rightBox    = $container.find( '.right' );
		var $rightSelect = $rightBox.find( '.select' );
		var $rightSearch = $rightBox.find( '.search' );

		// input field for the selected items. This will be used to save the data on post update.
		var $selectedItems = $container.find( '.cpb_selected_items' );

		// Pagination elements.
		var $paginationContainer = $container.find( '.left-pagination' );
		var	$paginationList = $paginationContainer.find( '.pagination' );

		// This config must be set using localize_scripts in wp.
		var config = dualListObj;

		 // This variable is used to store search results for each searched query string.
		dualList.cache = {
			lastSearchedQuery: '',
			cacheData: [],
			methods: {
				setLastSearchedQuery: function( query ) {
					dualList.cache.lastSearchedQuery = query;
				},
				getLastSearchedQuery: function() {
					return dualList.cache.lastSearchedQuery;
				},
				setData: function( key, pageNumber, data, totalPages ) {
					if ( 'undefined' == typeof dualList.cache.cacheData[ key ] ) {
						dualList.cache.cacheData[ key ] = [];
					}
					if ( 'undefined' == typeof dualList.cache.cacheData[ key ][ pageNumber ] ) {
						dualList.cache.cacheData[ key ][ pageNumber ] = null;
					}
					dualList.cache.cacheData[ key ][ pageNumber ] = data;
				},
				getData: function( key, pageNumber ) {
					var data = null;
					if ( 'undefined' != typeof dualList.cache.cacheData[ key ] ) {
						if ( -1 == pageNumber ) {
							data = dualList.cache.cacheData[ key ];
						} else if ( 'undefined' != typeof dualList.cache.cacheData[ key ][ pageNumber ] ) {
							data = dualList.cache.cacheData[ key ][ pageNumber ];
						}
					}
					return data;
				},
				resetCache: function() {
					dualList.cache.cacheData = [];
				}
			},
		};

		dualList.itemsList = {
			moveItem: function( $item, $destination, toOptgroup, moveType ) {
				if ( 'undefined' !== typeof toOptgroup && true === toOptgroup ) {
					if ( false === this.isOptgroupPresent( $destination ) ) {
						var label = '';
						if ( $destination.parent().hasClass( 'left' ) ) {
							label = config.leftOptLabel;
						// } else if ( $destination.hasClass( 'right-select' ) ) {
						} else if ( $destination.parent().hasClass( 'right' ) ) {
							label = config.rightOptLabel;
						}
						this.addOptgroup( $destination, label );
					}
				}
				this.addItem( $item, $destination, toOptgroup, moveType );
				
			},
			isOptgroupPresent: function( $element ) {
				if ( $element.find( '.ul-optgroup' ).length > 0 ) {
					return true;
				}
				return false;
			},
			addOptgroup: function( $element, label ) {
				$element.append( $( '<li class="ul-optgroup">' + label + '</li>' ) ); 
			},
			addItem: function( $item, $destination, toOptgroup, moveType ) {
				$destination.append( $item );
				$(document).trigger( 'on_addon_' + moveType + 'ed', [$item.data('extra')] );
				this.generateItemsList( $rightSelect, $selectedItems );
				this.changeStatus( moveType, $item.data( 'id' ) );
				this.scrollToEnd( $destination );
			},
			changeStatus: function( moveType, item_id ) {
				var updated_list = $( '.cpb_dual_list' ).find( '.cpb_selected_items' ).val();
				var action = 'disable_course_review';
				if ( 'remove' == moveType ) {
					action = 'enable_course_review';
					updated_list = JSON.stringify( [ item_id ] );
				}
				$.post(
					config.ajaxurl,
					{
						'action': action,
						'courses': updated_list 
					}
				);
			},
			// removeItem: function( $item ) {
			// 	$item.remove();
			// },
			scrollToEnd: function( $select ) {
				// var optionTop = $select.find( 'option' ).last().offset().top;
				var optionTop = $select.find( 'li' ).last().offset().top;
				var selectTop = $select.offset().top;

				$select.scrollTop( $select.scrollTop() + ( optionTop - selectTop ) );
			},
			searchInSelect: function( $select, query ) {
				$select.find('li').show();
				$select.find('li:notIcontains(' + query + ')').hide();
				$select.find('.ul-optgroup' ).show();
				// $select.find( 'li:visible').length;
			},
			generateItemsList: function( $select, $inputField ) {
				var ids = $select.find( 'li' ).map( function() {
				    return $( this ).data( 'id' );
				}).get();
				$inputField.val( JSON.stringify( ids ) );
			},
		};

		dualList.pagination = {
			generate: function( currentPage, totalPages, showNext ) {
				this.reset();

				var list = '';
				for ( pageNumber = 1; pageNumber <= totalPages; pageNumber++ ) {
					var activeClass = '';
					if ( pageNumber == currentPage ) {
						activeClass = ' active';
					}
					list += '<li><a href="javascript:void(0);" class="' + activeClass + '" data-page_number="' + pageNumber + '">' + pageNumber + '</a></li>';
				}
				if ( true === showNext ) {
					list += '<li><a href="javascript:void(0);" class="next" data-page_number="' + pageNumber + '">›</a></li>';
				}
				$paginationList.html( list );
				this.show();
			},
			reset: function() {
				$paginationList.html('');
				this.hide();
			},
			show: function() {
				$paginationContainer.show();
			},
			hide: function() {
				$paginationContainer.hide();
			}			
		};

		dualList.methods = {
			/**
			 * @memberOf dualList.methods
			 */
			ajax: function( data, beforeSend, error, success, dataType ) {
				dataType = dataType || 'json';

				$.ajax({
					method: 'POST',
					type: 'POST',
					url: config.ajaxurl,
					data: data,
					beforeSend: beforeSend,
					error: error,
					success: success,
					dataType: dataType,
				});
			},
			searchAjax: function( $select, query, pageNumber = 1 ) {
				var data = {
					nonce: config.nonce,
					query: query,
					action: config.ajaxActionName,
					pageNumber: pageNumber
				}
				this.ajax(
					data,
					function( xhr ) { // beforeSend
						$select.html( '' );
						dualList.methods.showBackgrounMessage( $select, config.dataLoadingString )
						dualList.pagination.reset();
					},
					function( jqXHR, exception ) { // error
						dualList.methods.showBackgrounMessage( $select, config.dataLoadingErrorString )
					},
					function( response ) { // success
						if ( Object.keys( response ).length > 0 ) {
							dualList.methods.removeBackgrounMessage( $select );
							var newList = '';
							$.each( response, function( ind, element ) {
								newList += dualList.methods.createLiItem( element );
							} );
							$select.html( newList );
							dualList.pagination.generate( pageNumber, pageNumber, true );
							dualList.cache.methods.setData( query, pageNumber, response );
						} else {
							dualList.methods.showBackgrounMessage( $select, config.noDataFoundString );
							dualList.pagination.generate( pageNumber, pageNumber, false );
						}
					},
				);
			},
			showBackgrounMessage: function( $element, message ) {
				$element.css( 'background-image', 'url("data:image/svg+xml;utf8,<svg xmlns=\'http://www.w3.org/2000/svg\' version=\'1.1\' height=\'50px\' width=\'100px\'><text x=\'0\' y=\'15\' fill=\'black\' font-size=\'14\'>' + message + '</text></svg>"' );
			},
			removeBackgrounMessage: function( $element ) {
				$element.css( 'background-image', '' );
			},
			createLiItem: function( responseElement ) {
				var tempEmptyLi = config.emptyLi;
				$.each( config.liReplace, function( repInd, repVal ) {
					var tempRegExp = new RegExp( repVal, 'g' ); // g = all occurances.
					tempEmptyLi = tempEmptyLi.replace( tempRegExp, responseElement[ repInd ] );
				} )
				return tempEmptyLi;
			},
		};

		/**
		 * @memberOf dualList
		 */
		dualList.preInit = function() {
			// $leftSelect.on( 'click', 'option', function() {
			$leftSelect.on( 'click', 'li', function() {
				if ( ! $( this ).hasClass( 'ul-optgroup' ) ) {
			    	// dualList.methods.moveItem( $( this ), $rightSelect, true );
			    	dualList.itemsList.moveItem( $( this ), $rightSelect, true, 'add' );
				}
			});
			// $rightSelect.on( 'click', 'option', function() {
			$rightSelect.on( 'click', 'li', function() {
				if ( ! $( this ).hasClass( 'ul-optgroup' ) ) {
			    	dualList.itemsList.moveItem( $( this ), $leftSelect, true, 'remove' );
			    }
			});

			// Searching items in the right select box.
			$rightSearch.on( 'keyup input', _.debounce( function( event, eventtype ) {
				dualList.itemsList.searchInSelect( $rightSelect, $( this ).val() );
			}, 500 ) );

			$leftSearch.on( 'keyup input', _.debounce( function( event, eventtype ) {

				var queryString = $.trim( $( this ).val() ).toLowerCase();

				if ( '' !== queryString && dualList.cache.methods.getLastSearchedQuery() !== queryString ) {
					dualList.cache.methods.setLastSearchedQuery( queryString )
					dualList.methods.searchAjax( $leftSelect, $( this ).val() );
				}
			}, 500 ) );

			$leftBox.on( 'click', '.pagination a', function() {
				var pageNumber = $( this ).attr( 'data-page_number' );
				var query = $leftSearch.val();
				var totalExistingPages = $( this ).closest( '.pagination' ).find( 'li' ).length;

				var cachedResult = dualList.cache.methods.getData( query, pageNumber );
				if ( null == cachedResult ) {
					dualList.methods.searchAjax( $leftSelect, query, pageNumber );
				} else {
					dualList.methods.removeBackgrounMessage( $leftSelect );
					var newList = '';
					$.each( cachedResult, function( ind, element ) {
						newList += dualList.methods.createLiItem( element );
					} );
					$leftSelect.html( newList );
					// Here reducing total pages by 1 because we have extra element for 'next' action.
					dualList.pagination.generate( pageNumber, ( totalExistingPages - 1 ) , true );
				}
			});

			// Trigger ajax on load.
			dualList.methods.searchAjax( $leftSelect, '' );
		};

		dualList.preInit();
	};

	$( document ).ready( function() {
		if ( $('.cpb_dual_list').length > 0 ) {
			new $.cpbDualList( '.cpb_dual_list' );
		}
	})

	/**
	 * Filters case insensitive.
	 * @reference: https://stackoverflow.com/questions/8746882/jquery-contains-selector-uppercase-and-lower-case-issue?answertab=votes#tab-top
	 */
	$.expr[':'].icontains = function( a, i, m ) {
	  return jQuery( a ).text().toUpperCase()
	      .indexOf( m[3].toUpperCase() ) >= 0;
	};
	/**
	 * This is modified version of icontains to find out the options which do not contains.
	 */
	$.expr[':'].notIcontains = function( a, i, m ) {
	  return jQuery( a ).text().toUpperCase()
	      .indexOf( m[3].toUpperCase() ) < 0;
	};
	function cl( string ) {
		console.log( string );
	}
})(jQuery);
