( function ( $ ) {
	$( document ).ready( function () {

		//Require post title when adding/editing Project Summaries
		$( 'body' ).on( 'submit.edit-post', '#post', function () {

			// If the title isn't set
			if ( $( "#title" ).val().replace( / /g, '' ).length === 0 ) {

				// Show the alert
				window.alert( 'A title is required.' );

				// Hide the spinner
				$( '#major-publishing-actions .spinner' ).hide();

				// The buttons get "disabled" added to them on submit. Remove that class.
				$( '#major-publishing-actions' ).find( ':button, :submit, a.submitdelete, #post-preview' ).removeClass( 'disabled' );

				// Focus on the title field.
				$( "#title" ).focus();

				return false;
			}
			var answer_set = false;
			$( ".rff-survey-question-option-main input" ).each( function( ind, el ) {
				if( ! $( el ).val() ) {
					answer_set = false;
					return false;
				}
				answer_set = true;
				return true;
			} );
			if ( false === answer_set ) {
				// Show the alert
				window.alert( 'Empty/No Answers are not permitted.' );

				// Hide the spinner
				$( '#major-publishing-actions .spinner' ).hide();

				// The buttons get "disabled" added to them on submit. Remove that class.
				$( '#major-publishing-actions' ).find( ':button, :submit, a.submitdelete, #post-preview' ).removeClass( 'disabled' );
				// Focus on the title field.
				$( "#rrf_question_option" ).focus();

				return false;
			}
		});
	});
}( jQuery ) );