<?php
/**
 * Partial: Page - Import/Export.
 *
 * @var object
 * @package RatingsReviewsFeedback\Admin
 */

?>
<form id="export-form" method="post">
	<table class="form-table">
		<tbody class="import-export-body">
			<tr>
				<th scope="row"><label for="wdm_course_review_setting"><?php esc_html_e( 'Select Courses', 'wdm_ld_course_review' ); ?></label></th>
				<td>
					<select name="page_id" id="course_dropdown" multiple>
					<?php
					$args = array(
						'post_type'   => 'sfwd-courses',
						'numberposts' => -1,
					);

					// @codingStandardsIgnoreLine
					$posts = get_posts( $args );
					// @codingStandardsIgnoreLine
					foreach ( $posts as $post ) :
						?>
						<option value='<?php echo esc_html( $post->ID ); ?>'><?php echo $post->post_title; ?></option>
					<?php endforeach; ?>
					</select>
					<p class="description" id="wdm-review-setting"><?php esc_html_e( 'Select courses for course specific reviews.', 'wdm_ld_course_review' ); ?></p>
				</td>
			</tr>
			<?php
				do_action( 'rrf_export_form_template' );
			?>
		</tbody>
	</table>
	<?php wp_nonce_field( 'wdm_review_setting_export_nonce', 'wdm_review_setting_export_nonce' ); ?>
	<p class="submit" id="export_form_link">
		<input type="submit" name="submit" id="submit2" class="button button-primary" value="Export">
		<span class="download_links"></span>
	</p>
</form>
