<?php
/*
Plugin Name: WDM Customizations
Plugin URI: https://wisdmlabs.com/
Description: Includes customization for instructors
Version: 1.0
Author: WisdmLabs
Author URI: https://wisdmlabs.com/
*/




function wdm_instructor_settings_checkbox( $profileuser ) {
    // var_dump(get_user_meta( $profileuser->ID, 'wdm_instructor_settings'));die();
    ?>
    <table class="form-table">
        <tbody>
            <tr class="user-instructor-settings-wrap">
                <th><label for="wdm_instructor_settings">Instructor Level Access</label></th>
                
                <td>
                    <input type="checkbox" name="wdm_instructor_settings" id="wdm_instructor_settings" value="1" <?php echo ( get_user_meta(  $profileuser->ID, 'wdm_instructor_settings', true ) == 1 ) ? 'checked' : ''; ?>>
                </td>
            </tr>
        </tbody>
    </table>
    <?php
}
add_action( 'edit_user_profile', 'wdm_instructor_settings_checkbox', 10, 1 );

function wdm_save_instructor_settings( $user_id ) {
    if ( ! current_user_can( 'edit_user', $user_id ) ) {
        return false;
    }
    update_user_meta( $user_id, 'wdm_instructor_settings', (int) isset( $_POST['wdm_instructor_settings'] ) ? sanitize_key( $_POST['wdm_instructor_settings'] ) : 0 );
}
add_action( 'edit_user_profile_update', 'wdm_save_instructor_settings' );


add_action('wp', 'wdm_group_leader_restrict_access' );
function wdm_group_leader_restrict_access() {

    $user = wp_get_current_user();
    $user_id = $user->ID;

    $user_roles = $user->roles;
    if ( in_array( 'group_leader', $user_roles ) ) {
        if ( (int) get_user_meta( $user_id, 'wdm_instructor_settings', true ) !== 1 ) {
            var_dump('yes');
            ?>
            <style>
                #wdm_groups_tab .enroll-new-user {
                    display: none !important;
                }
                #wdm_groups_tab #bulk_remove {
                    display: none;
                }
            </style>
            <?php
        }
    }
}