<?php
/*
Plugin Name: WDM Migration Script
Plugin URI: https://wisdmlabs.com/
Description: Migration script for WDM plugin
Version: 1.0
Author: WisdmLabs
Author URI: https://wisdmlabs.com/
*/


/**
 * Read a CSV file from wp-content/plugins/wdm-migration-script and extract CSV columns in different rows
 */
function csv_to_array($file_path) {

    $rows = array_map('str_getcsv', file($file_path));
    $header = array_shift($rows);
    $data = array();
    foreach ($rows as $row) {
        $data[] = array_combine($header, $row);
    }
    return $data;
}



add_action( 'cli_init', function() {
    WP_CLI::add_command('wdm-migrate-progress', 'Wdm_Progress_Migrate');
    WP_CLI::add_command('wdm-add-roles', 'Wdm_Role_Migrate');
} );


/**
 * Implements a custom command.
 */
class Wdm_Progress_Migrate {

    /**
     * Prints a greeting.
     *
     * ## OPTIONS
     *
     * <file_path>...
     * : File path of the course progress export
     * 
     *
     * ## EXAMPLES
     *
     *     wp wdm-migrate-progress migrate "/file.cs"
     *
     * @when after_wp_load
     */
    function migrate( $args, $assoc_args ) {
        
        $file_path = $args[0];
        $column_name = $args[1];
        $course_id = basename($file_path, ".csv");

        $file_path = plugin_dir_path(__FILE__) . $file_path;
        if (!file_exists($file_path)) {
            WP_CLI::error("File not found: $file_path");
            return;
        }

        if( is_null(get_post($course_id))){

            WP_CLI::error("Course ID does not exist");
            return;
        }
        $data = csv_to_array($file_path);

        foreach($data as $row) {
            $user_email = $row['Email address'];

            $user = get_user_by('email', $user_email);
            $user_id = $user->ID;
            $completed_time = strtotime($row['']);
            $group_name = $row['Institution'];

            $group_present = get_posts( array(
                'post_status' => 'publish',
                'post_type' => 'groups',
                'title' => $group_name,
            ) );

            $group_id = $group_present[0]->ID;

            if( $group_name && !$group_present ) {
                $group_id = wp_insert_post(
                array(
                    'post_title' => $group_name,
                    'post_type' => 'groups',
                    'post_status' => 'publish',
                    )
                );
            }
            
            $user_group_ids = learndash_get_users_group_ids( $user_id );
            if( !in_array( $group_id, $user_group_ids ) ) {
                $user_group_ids[] = $group_id;
                learndash_set_users_group_ids( $user_id, $user_group_ids );
            }
                    

            if( !sfwd_lms_has_access( $course_id, $user_id ) ) {
                ld_update_course_access( $user_id, $course_id, false );
            }

            //Skip if course has already been completed for merging progress.
            if( learndash_course_completed( $user_id,  $course_id ) ) {
                continue;
            }
            
            if( $row[$column_name] == "Completed" ) {
                $child_steps = learndash_course_get_children_of_step($course_id);

                foreach($child_steps as $child_step) {
                    learndash_process_mark_complete( $user_id, $child_step, true, $course_id );
                    
                }

                learndash_process_mark_complete( $user_id, $course_id, true );
                learndash_activity_complete_course( $user_id, $course_id, $completed_time );
                update_user_meta($user_id, 'course_completed_' . $course_id, $completed_time);


            }
            WP_CLI::success("Done for user: $user_email");
        }
    }
}



class Wdm_Role_Migrate {

    /**
     * Prints a greeting.
     *
     * ## OPTIONS
     *
     * <file_path>
     * : File path of the Role export
     *
     * ## EXAMPLES
     *
     *     wp wdm-add-roles add "/file.cs"
     *
     * @when after_wp_load
     */
    function add( $args, $assoc_args ) {
        
        $file_path = $args[0];

        $file_path = plugin_dir_path(__FILE__) . $file_path;
        if (!file_exists($file_path)) {
            WP_CLI::error("File not found: $file_path");
            return;
        }

        $data = csv_to_array($file_path);

        foreach($data as $row) {
            $username = $row['username'];
            $user = get_user_by('login', $username);
            $role_id = $row['roleid'];
            
            if( $user ) {
                if($role_id == "1") {
                    $user->set_role( 'administrator' );
                }

                if($role_id == "3") {
                    $user->set_role( 'group_leader' );
                    update_user_meta( $user->ID, 'wdm_instructor_settings', 1 );
                }

                if($role_id == "9") {
                    $user->set_role( 'group_leader' );
                }

                if($role_id == "10") {
                    $user->set_role( 'administrator' );
                }
                WP_CLI::success("User role changed for user: $username");

            } else {
                WP_CLI::success("User not found: $username");
            }
        }
    }
}