
// Check if the method includes is defined
if ( ! String.prototype.includes ){
	// Otherwise, define it
    String.prototype.includes = function( search, start ){
        if ( typeof start !== 'number' ){
            start = 0;
        }

        if ( start + search.length > this.length ){
            return false;
        } else {
            return this.indexOf(search, start) !== -1;
        }
    };
}

// Define function to get parameters from the URL
function getParameterByName(name, url) {
    if (!url) url = window.location.href;
    name = name.replace(/[\[\]]/g, "\$&");
    var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
        results = regex.exec(url);
    if (!results) return null;
    if (!results[2]) return '';
    return decodeURIComponent(results[2].replace(/\+/g, " "));
}

var actor = JSON.parse(getParameterByName('actor'));
var baseUrl = getParameterByName('base_url');
var nonce = getParameterByName('nonce');
var email = actor.mbox[0].replace('mailto:', '');
var postId = getParameterByName('auth').replace('LearnDashId', '');
window.InitUserScripts = function()
{
var player = GetPlayer();
var object = player.object;
var once = player.once;
var addToTimeline = player.addToTimeline;
var setVar = player.SetVar;
var getVar = player.GetVar;
var update = player.update;
var pointerX = player.pointerX;
var pointerY = player.pointerY;
var showPointer = player.showPointer;
var hidePointer = player.hidePointer;
var slideWidth = player.slideWidth;
var slideHeight = player.slideHeight;
};
